/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.items.alchemy;

import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.BasicItem;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.iwolfking.woldsvaults.api.util.ComponentUtils;
import xyz.iwolfking.woldsvaults.blocks.BrewingAltar;
import xyz.iwolfking.woldsvaults.blocks.tiles.BrewingAltarTileEntity;
import xyz.iwolfking.woldsvaults.config.AlchemyObjectiveConfig;
import xyz.iwolfking.woldsvaults.events.vaultevents.BrewingAltarBrewEvent;
import xyz.iwolfking.woldsvaults.init.ModItems;
import xyz.iwolfking.woldsvaults.objectives.AlchemyObjective;

public class CatalystItem
extends BasicItem {
    private final CatalystType type;

    public CatalystItem(ResourceLocation id, CatalystType type) {
        super(id);
        this.type = type;
    }

    @NotNull
    public Component m_7626_(ItemStack pStack) {
        Item item = pStack.m_41720_();
        if (!(item instanceof CatalystItem)) {
            return super.m_7626_(pStack);
        }
        CatalystItem it = (CatalystItem)item;
        String baseName = "Catalyst of " + (switch (it.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case CatalystType.STABILIZING -> "Stability";
            case CatalystType.AMPLIFYING -> "Amplification";
            case CatalystType.FOCUSING -> "Focus";
            case CatalystType.TEMPORAL -> "Haste";
            case CatalystType.UNSTABLE -> "Instability";
        });
        return ComponentUtils.wavingComponent((MutableComponent)new TextComponent(baseName), 16238343, 0.2f, 0.4f);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        switch (((CatalystItem)stack.m_41720_()).getType()) {
            case STABILIZING: {
                tooltip.add((Component)new TextComponent("- ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)).m_7220_((Component)new TextComponent("50% Chance ").m_130948_(Style.f_131099_.m_178520_(15787660))).m_7220_((Component)new TextComponent("to stabilize ").m_130948_(Style.f_131099_).m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent("the Brew ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent("and ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent("prevent ").m_130948_(Style.f_131099_.m_178520_(15787660))).m_7220_((Component)new TextComponent("a ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent("Negative Modifier").m_130948_(Style.f_131099_.m_178520_(14423100))).m_7220_((Component)new TextComponent(".").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))));
                break;
            }
            case AMPLIFYING: {
                tooltip.add((Component)new TextComponent("- Amplifies ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)).m_7220_((Component)new TextComponent("Vault Progression ").m_130948_(Style.f_131099_.m_178520_(15787660))).m_7220_((Component)new TextComponent("between ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent("25% - 75%").m_130948_(Style.f_131099_.m_178520_(15787660))).m_7220_((Component)new TextComponent(".").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))));
                break;
            }
            case FOCUSING: {
                tooltip.add((Component)new TextComponent("").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)).m_7220_((Component)new TextComponent("If ").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent("all the ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent("Ingredients ").m_130948_(Style.f_131099_.m_178520_(15787660))).m_7220_((Component)new TextComponent("are ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent("equal").m_130948_(Style.f_131099_.m_178520_(15787660))).m_7220_((Component)new TextComponent(":").m_130948_(Style.f_131099_)));
                tooltip.add((Component)new TextComponent("- ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)).m_7220_((Component)new TextComponent("Doubles ").m_130948_(Style.f_131099_.m_178520_(7273077))).m_7220_((Component)new TextComponent("the effect ").m_130948_(Style.f_131099_.m_178520_(15787660))).m_7220_((Component)new TextComponent("of ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent("the Brew").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent(". ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))));
                break;
            }
            case TEMPORAL: {
                tooltip.add((Component)new TextComponent("- ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)).m_7220_((Component)new TextComponent("Protects ").m_130948_(Style.f_131099_.m_178520_(15787660))).m_7220_((Component)new TextComponent("the ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent("Brewing Altar ").m_130948_(Style.f_131099_.m_178520_(15787660))).m_7220_((Component)new TextComponent("from ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent("decay").m_130948_(Style.f_131099_.m_178520_(16408425))).m_7220_((Component)new TextComponent(". ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))));
                break;
            }
            case UNSTABLE: {
                tooltip.add((Component)new TextComponent("- ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)).m_7220_((Component)new TextComponent("Causes ").m_130948_(Style.f_131099_)).m_7220_((Component)new TextComponent("the Brew ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent("to ").m_130948_(Style.f_131099_)).m_7220_((Component)new TextComponent("randomize").m_130948_(Style.f_131099_.m_178520_(15787660))).m_7220_((Component)new TextComponent(".").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))));
            }
        }
    }

    public CatalystType getType() {
        return this.type;
    }

    public static ItemStack createRandomCatalyst(Vault vault, Random random) {
        List<CatalystItem> catalysts = List.of(ModItems.CATALYST_UNSTABLE, ModItems.CATALYST_AMPLIFYING, ModItems.CATALYST_FOCUSING, ModItems.CATALYST_STABILITY, ModItems.CATALYST_TEMPORAL);
        ItemStack stack = new ItemStack((ItemLike)catalysts.get(random.nextInt(catalysts.size())));
        stack.m_41784_().m_128359_("VaultId", ((UUID)vault.get(Vault.ID)).toString());
        return stack;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum CatalystType {
        STABILIZING{

            @Override
            public void applyEffect(VirtualWorld world, AlchemyObjective obj, AlchemyObjectiveConfig.Entry cfg, BrewingAltarBrewEvent.Data data, Map<VaultModifier<?>, Integer> modifierMap, List<ResourceLocation> chosenPools, BrewingAltarTileEntity.PercentageResult result) {
                if (JavaRandom.ofNanoTime().nextBoolean()) {
                    ResourceLocation removedNegativePool = null;
                    Iterator<ResourceLocation> poolIterator = chosenPools.iterator();
                    while (poolIterator.hasNext()) {
                        ResourceLocation pool = poolIterator.next();
                        if (!pool.equals((Object)cfg.getNegativeModifierPool()) && !pool.equals((Object)cfg.getStrongNegativeModifierPool())) continue;
                        removedNegativePool = pool;
                        poolIterator.remove();
                        break;
                    }
                    if (removedNegativePool != null && !modifierMap.isEmpty()) {
                        modifierMap.clear();
                        JavaRandom random = JavaRandom.ofNanoTime();
                        for (ResourceLocation mod : chosenPools) {
                            for (VaultModifier modifier : ModConfigs.VAULT_MODIFIER_POOLS.getRandom(mod, ((Integer)obj.get(AlchemyObjective.VAULT_LEVEL)).intValue(), (RandomSource)random)) {
                                modifierMap.put(modifier, 1);
                            }
                        }
                        world.m_6907_().forEach(player -> player.m_6352_((Component)new TextComponent("The Potion has been cleansed by the Catalyst.").m_130948_(Style.f_131099_.m_178520_(15787660)), Util.f_137441_));
                    }
                } else {
                    world.m_6907_().forEach(player -> player.m_6352_((Component)new TextComponent("The Catalyst fails.").m_130940_(ChatFormatting.RED), Util.f_137441_));
                }
            }
        }
        ,
        AMPLIFYING{

            @Override
            public void applyEffect(VirtualWorld world, AlchemyObjective obj, AlchemyObjectiveConfig.Entry cfg, BrewingAltarBrewEvent.Data data, Map<VaultModifier<?>, Integer> modifierMap, List<ResourceLocation> chosenPools, BrewingAltarTileEntity.PercentageResult result) {
                float boostFactor = 1.0f + (0.25f + JavaRandom.ofNanoTime().nextFloat() * 0.5f);
                result.setMin(data.getEntity().getProgressIncrease().min() * boostFactor);
                result.setMax(data.getEntity().getProgressIncrease().max() * boostFactor);
                String formatted = String.format("%.1f%%", Float.valueOf((boostFactor - 1.0f) * 100.0f));
                world.m_6907_().forEach(player -> player.m_6352_((Component)new TextComponent("The potion has been amplified ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)).m_7220_((Component)new TextComponent("by " + formatted + " ").m_130948_(Style.f_131099_.m_178520_(15787660))).m_7220_((Component)new TextComponent("with the Catalyst.").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))), Util.f_137441_));
            }
        }
        ,
        FOCUSING{

            @Override
            public void applyEffect(VirtualWorld world, AlchemyObjective obj, AlchemyObjectiveConfig.Entry cfg, BrewingAltarBrewEvent.Data data, Map<VaultModifier<?>, Integer> modifierMap, List<ResourceLocation> chosenPools, BrewingAltarTileEntity.PercentageResult result) {
                boolean allSame;
                boolean bl = allSame = data.getIngredients().stream().map(ItemStack::m_41720_).distinct().count() == 1L;
                if (allSame) {
                    result.setMin(data.getEntity().getProgressIncrease().min() * 2.0f);
                    result.setMax(data.getEntity().getProgressIncrease().max() * 2.0f);
                    modifierMap.replaceAll((mod, val) -> val * 2);
                    world.m_6907_().forEach(player -> player.m_6352_((Component)new TextComponent("The modifiers have been doubled by the Catalyst").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)), Util.f_137441_));
                }
            }
        }
        ,
        TEMPORAL{

            @Override
            public void applyEffect(VirtualWorld world, AlchemyObjective obj, AlchemyObjectiveConfig.Entry cfg, BrewingAltarBrewEvent.Data data, Map<VaultModifier<?>, Integer> modifierMap, List<ResourceLocation> chosenPools, BrewingAltarTileEntity.PercentageResult result) {
                int newUses = Math.min(5, (Integer)data.getEntity().m_58900_().m_61143_((Property)BrewingAltar.USES) + 1);
                BlockState newState = (BlockState)data.getEntity().m_58900_().m_61124_((Property)BrewingAltar.USES, (Comparable)Integer.valueOf(newUses));
                world.m_7731_(data.getPos(), newState, 3);
                world.m_6907_().forEach(player -> player.m_6352_((Component)new TextComponent("The altar remains stable.").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)), Util.f_137441_));
            }
        }
        ,
        UNSTABLE{

            @Override
            public void applyEffect(VirtualWorld world, AlchemyObjective obj, AlchemyObjectiveConfig.Entry cfg, BrewingAltarBrewEvent.Data data, Map<VaultModifier<?>, Integer> modifierMap, List<ResourceLocation> chosenPools, BrewingAltarTileEntity.PercentageResult result) {
                modifierMap.clear();
                List<ResourceLocation> allPools = List.of(cfg.getNegativeModifierPool(), cfg.getStrongNegativeModifierPool(), cfg.getPositiveModifierPool(), cfg.getStrongPositiveModifierPool());
                JavaRandom random = JavaRandom.ofNanoTime();
                for (int i = 0; i < 2 + random.nextInt(3); ++i) {
                    ResourceLocation pool = allPools.get(random.nextInt(allPools.size()));
                    List mods = ModConfigs.VAULT_MODIFIER_POOLS.getRandom(pool, ((Integer)obj.get(AlchemyObjective.VAULT_LEVEL)).intValue(), (RandomSource)random);
                    if (mods.isEmpty()) continue;
                    VaultModifier picked = (VaultModifier)mods.get(random.nextInt(mods.size()));
                    modifierMap.put(picked, 1);
                }
                float randMin = -0.9f + random.nextFloat() * 1.8f;
                float randMax = -0.9f + random.nextFloat() * 1.8f;
                float finalMin = Math.min(randMin, randMax);
                float finalMax = Math.max(randMin, randMax);
                result.setMin(finalMin);
                result.setMax(finalMax);
                world.m_6907_().forEach(player -> player.m_6352_((Component)new TextComponent("The brew has been randomized by the Catalyst").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)), Util.f_137441_));
            }
        };


        public abstract void applyEffect(VirtualWorld var1, AlchemyObjective var2, AlchemyObjectiveConfig.Entry var3, BrewingAltarBrewEvent.Data var4, Map<VaultModifier<?>, Integer> var5, List<ResourceLocation> var6, BrewingAltarTileEntity.PercentageResult var7);
    }
}

