/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.items.fruits;

import iskallia.vault.VaultMod;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.item.ItemVaultFruit;
import iskallia.vault.world.data.ServerVaults;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import xyz.iwolfking.woldsvaults.api.util.VaultModifierUtils;

public class HastyPomegranteItem
extends ItemVaultFruit {
    private static final Random rand = new Random();

    public HastyPomegranteItem(ResourceLocation id, int extraVaultTicks) {
        super(id, extraVaultTicks);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag tooltipFlag) {
        int seconds = Mth.m_14143_((float)((float)this.extraVaultTicks / 20.0f));
        String timeText = String.format("%d seconds", seconds);
        if (seconds > 90) {
            int minutes = seconds / 60;
            timeText = String.format("%d minutes", minutes);
        }
        MutableComponent cmp = new TextComponent("Adds ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(timeText).m_130940_(ChatFormatting.GREEN)).m_130946_(" to the Vault timer");
        tooltip.add(TextComponent.f_131282_);
        tooltip.add((Component)new TextComponent("Adds").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(" 2x Rapid Mobs").m_130940_(ChatFormatting.RED)).m_7220_((Component)new TextComponent(" to the Vault (max 6)").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)new TextComponent("Removes").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(" 10% max health").m_130940_(ChatFormatting.RED)).m_7220_((Component)new TextComponent(" after 6 stacks have been added.").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)cmp);
        tooltip.add(TextComponent.f_131282_);
        tooltip.add((Component)new TextComponent("Only edible inside a Vault").m_130940_(ChatFormatting.RED));
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entityLiving) {
        if (!level.m_5776_() && entityLiving instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entityLiving;
            if (!this.onEaten(level, (Player)player)) {
                return stack;
            }
            if (ServerVaults.get((Level)level).isPresent()) {
                Vault vault = (Vault)ServerVaults.get((Level)level).get();
                int rapidMobsCount = 0;
                for (VaultModifier mod : ((Modifiers)vault.get(Vault.MODIFIERS)).getModifiers()) {
                    if (!mod.getId().equals((Object)VaultMod.id((String)"infuriated_mobs"))) continue;
                    ++rapidMobsCount;
                }
                if (rapidMobsCount >= 6) {
                    this.reducePlayerMaxHealth(player);
                } else {
                    this.successEaten(level, player);
                }
            }
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11767_, SoundSource.MASTER, 1.0f, 1.0f);
        }
        return entityLiving.m_5584_(level, stack);
    }

    protected void successEaten(Level level, ServerPlayer sPlayer) {
        if (ServerVaults.get((Level)level).isPresent()) {
            Vault vault = (Vault)ServerVaults.get((Level)level).get();
            VaultModifier modifier = VaultModifierRegistry.get((ResourceLocation)VaultMod.id((String)"infuriated_mobs"));
            if (modifier != null) {
                VaultModifierUtils.sendModifierAddedMessage(sPlayer, modifier, 2);
                ((Modifiers)vault.get(Vault.MODIFIERS)).addModifier(modifier, 2, true, (RandomSource)ChunkRandom.any());
            }
        }
    }
}

