/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.items.gear;

import com.google.common.collect.Multimap;
import iskallia.vault.gear.VaultGearClassification;
import iskallia.vault.gear.VaultGearHelper;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.VaultGearType;
import iskallia.vault.gear.crafting.ProficiencyType;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.tooltip.GearTooltip;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.BasicItem;
import iskallia.vault.world.data.DiscoveredModelsData;
import java.util.List;
import java.util.Random;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.iwolfking.woldsvaults.init.ModGearAttributes;

public class VaultMapItem
extends BasicItem
implements VaultGearItem {
    Random rand = new Random();

    public VaultMapItem(ResourceLocation id, Item.Properties properties) {
        super(id, properties);
    }

    @NotNull
    public VaultGearClassification getClassification(ItemStack itemStack) {
        return VaultGearClassification.valueOf((String)"MAP");
    }

    @NotNull
    public ProficiencyType getCraftingProficiencyType(ItemStack itemStack) {
        return ProficiencyType.UNKNOWN;
    }

    @NotNull
    public VaultGearType getGearType(ItemStack itemStack) {
        return VaultGearType.IDOL;
    }

    @javax.annotation.Nullable
    public ResourceLocation getRandomModel(ItemStack stack, Random random, @javax.annotation.Nullable Player player, @javax.annotation.Nullable DiscoveredModelsData discoveredModelsData) {
        VaultGearData gearData = VaultGearData.read((ItemStack)stack);
        EquipmentSlot intendedSlot = this.getGearType(stack).getEquipmentSlot();
        return ModConfigs.GEAR_MODEL_ROLL_RARITIES.getRandomRoll(stack, gearData, intendedSlot, random, player, discoveredModelsData);
    }

    public void tickRoll(ItemStack stack, @Nullable Player player) {
        VaultGearData data = VaultGearData.read((ItemStack)stack);
        if (data.getState() != VaultGearState.IDENTIFIED) {
            int tier = data.getFirstValue(ModGearAttributes.MAP_TIER).orElse(-1);
            if (tier == -1) {
                float randChance = this.rand.nextFloat();
                if (randChance <= 0.05f) {
                    data.createOrReplaceAttributeValue(ModGearAttributes.MAP_TIER, (Object)5);
                } else if (randChance <= 0.15f) {
                    data.createOrReplaceAttributeValue(ModGearAttributes.MAP_TIER, (Object)4);
                } else if (randChance <= 0.35f) {
                    data.createOrReplaceAttributeValue(ModGearAttributes.MAP_TIER, (Object)3);
                } else if (randChance <= 0.6f) {
                    data.createOrReplaceAttributeValue(ModGearAttributes.MAP_TIER, (Object)2);
                } else if (randChance <= 0.75f) {
                    data.createOrReplaceAttributeValue(ModGearAttributes.MAP_TIER, (Object)1);
                } else {
                    data.createOrReplaceAttributeValue(ModGearAttributes.MAP_TIER, (Object)0);
                }
            }
            data.write(stack);
        }
        super.tickRoll(stack, player);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            items.add((Object)this.defaultItem());
        }
    }

    public int getDefaultTooltipHideFlags(@NotNull ItemStack stack) {
        return super.getDefaultTooltipHideFlags(stack) | ItemStack.TooltipPart.MODIFIERS.m_41809_();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return VaultGearHelper.getModifiers((ItemStack)stack, (EquipmentSlot)slot);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return VaultGearHelper.shouldPlayGearReequipAnimation((ItemStack)oldStack, (ItemStack)newStack, (boolean)slotChanged);
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return 1;
    }

    public Component m_7626_(ItemStack stack) {
        return VaultGearHelper.getDisplayName((ItemStack)stack, (Component)super.m_7626_(stack));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        return VaultGearHelper.rightClick((Level)world, (Player)player, (InteractionHand)hand, (InteractionResultHolder)super.m_7203_(world, player, hand));
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.vaultGearTick(stack, player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        tooltip.addAll(this.createTooltip(stack, GearTooltip.itemTooltip()));
    }

    public void addRepairTooltip(List<Component> tooltip, int usedRepairs, int totalRepairs) {
    }

    public void addSlotTooltip(List<Component> tooltip, EquipmentSlot slot) {
    }

    public void addTooltipItemLevel(VaultGearData data, ItemStack stack, List<Component> tooltip, VaultGearState state) {
        if (data.hasAttribute(ModGearAttributes.MAP_TIER)) {
            int tier = data.getFirstValue(ModGearAttributes.MAP_TIER).orElse(0);
            tooltip.add((Component)new TextComponent("Tier: ").m_7220_((Component)new TextComponent(String.valueOf(tier)).m_130948_(Style.f_131099_.m_178520_(this.getTierColor(tier)))));
        } else if (stack.m_41784_().m_128441_("the_vault:map_tier")) {
            int tier = stack.m_41784_().m_128451_("the_vault:map_tier");
            if (tier == -1) {
                tooltip.add((Component)new TextComponent("Tier: ").m_7220_((Component)new TextComponent("???").m_130948_(Style.f_131099_.m_178520_(7247291))));
            } else {
                tooltip.add((Component)new TextComponent("Tier: ").m_7220_((Component)new TextComponent(String.valueOf(tier)).m_130948_(Style.f_131099_.m_178520_(this.getTierColor(tier)))));
            }
        } else {
            tooltip.add((Component)new TextComponent("Tier: ").m_7220_((Component)new TextComponent("???").m_130948_(Style.f_131099_.m_178520_(7247291))));
        }
    }

    public int getTierColor(int tier) {
        return switch (tier) {
            case 9 -> 7877375;
            case 8 -> 9974527;
            case 7 -> 9974403;
            case 6 -> 9974337;
            case 5 -> 3307654;
            case 4 -> 3295110;
            case 3 -> 3295017;
            case 2 -> 3374592;
            case 1 -> 0x8CFFFF;
            default -> 0xDAFFFF;
        };
    }
}

