/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.items.gear;

import cofh.ensorcellation.init.EnsorcEnchantments;
import com.google.common.collect.Multimap;
import iskallia.vault.dynamodel.DynamicModel;
import iskallia.vault.gear.VaultGearClassification;
import iskallia.vault.gear.VaultGearHelper;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.VaultGearType;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.crafting.ProficiencyType;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.tooltip.GearTooltip;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.BasicItem;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.world.data.DiscoveredModelsData;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import vazkii.quark.base.handler.QuarkSounds;
import xyz.iwolfking.woldsvaults.data.enchantments.AllowedEnchantmentsData;
import xyz.iwolfking.woldsvaults.items.gear.rang.VaultRangEntity;
import xyz.iwolfking.woldsvaults.models.Rangs;

public class VaultRangItem
extends BasicItem
implements VaultGearItem,
DyeableLeatherItem {
    public VaultRangItem(ResourceLocation id, Item.Properties properties) {
        super(id, properties);
    }

    public boolean m_8096_(@Nonnull BlockState blockIn) {
        return false;
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return VaultGearHelper.getDisplayName((ItemStack)stack, (Component)super.m_7626_(stack));
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        int cooldown;
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (VaultGearHelper.rightClick((Level)worldIn, (Player)playerIn, (InteractionHand)handIn, (InteractionResultHolder)super.m_7203_(worldIn, playerIn, handIn)).m_19089_().equals((Object)InteractionResult.FAIL)) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        VaultGearData data = VaultGearData.read((ItemStack)itemstack);
        if (data.getItemLevel() > SidedHelper.getVaultLevel((Player)playerIn)) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
        }
        playerIn.m_21008_(handIn, ItemStack.f_41583_);
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)playerIn);
        float velocity = ((Float)snapshot.getAttributeValue(ModGearAttributes.VELOCITY, VaultGearAttributeTypeMerger.floatSum())).floatValue() * 100.0f;
        Double attackSpeed = (Double)snapshot.getAttributeValue(ModGearAttributes.ATTACK_SPEED, VaultGearAttributeTypeMerger.doubleSum());
        Vec3 pos = playerIn.m_20182_();
        worldIn.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, QuarkSounds.ENTITY_PICKARANG_THROW, SoundSource.NEUTRAL, 0.5f + velocity * 0.14f, 0.4f / (worldIn.f_46441_.nextFloat() * 0.4f + 0.8f));
        if (!worldIn.f_46443_) {
            Inventory inventory = playerIn.m_150109_();
            int slot = handIn == InteractionHand.OFF_HAND ? inventory.m_6643_() - 1 : inventory.f_35977_;
            VaultRangEntity entity = new VaultRangEntity(worldIn, (LivingEntity)playerIn);
            entity.setThrowData(slot, itemstack, snapshot);
            entity.shoot((Entity)playerIn, playerIn.m_146909_(), playerIn.m_146908_(), 0.0f, 1.5f + velocity * 0.325f, 0.0f);
            worldIn.m_7967_((Entity)entity);
        }
        if (!playerIn.m_150110_().f_35937_ && (cooldown = 10 - attackSpeed.intValue()) > 0) {
            playerIn.m_36335_().m_41524_((Item)this, cooldown);
        }
        playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        boolean result = super.m_7579_(pStack, pTarget, pAttacker);
        pTarget.m_20256_(Vec3.f_82478_);
        Vec3 dir = pAttacker.m_20154_().m_82541_();
        pTarget.m_5997_(dir.f_82479_ * 0.05, 0.05, dir.f_82481_ * 0.05);
        return result;
    }

    public float m_8102_(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        return 0.0f;
    }

    public Optional<? extends DynamicModel<?>> resolveDynamicModel(ItemStack stack, ResourceLocation key) {
        return Rangs.REGISTRY.get(key);
    }

    @NotNull
    public VaultGearClassification getClassification(ItemStack itemStack) {
        return VaultGearClassification.SWORD;
    }

    @NotNull
    public ProficiencyType getCraftingProficiencyType(ItemStack itemStack) {
        return ProficiencyType.SWORD;
    }

    @NotNull
    public VaultGearType getGearType(ItemStack itemStack) {
        return VaultGearType.SWORD;
    }

    @Nullable
    public ResourceLocation getRandomModel(ItemStack stack, Random random, @Nullable Player player, @Nullable DiscoveredModelsData discoveredModelsData) {
        VaultGearData gearData = VaultGearData.read((ItemStack)stack);
        EquipmentSlot intendedSlot = this.getGearType(stack).getEquipmentSlot();
        return ModConfigs.GEAR_MODEL_ROLL_RARITIES.getRandomRoll(stack, gearData, intendedSlot, random, player, discoveredModelsData);
    }

    public int getDefaultTooltipHideFlags(@NotNull ItemStack stack) {
        return super.getDefaultTooltipHideFlags(stack) | ItemStack.TooltipPart.MODIFIERS.m_41809_();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return VaultGearHelper.getModifiers((ItemStack)stack, (EquipmentSlot)slot);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.vaultGearTick(stack, player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        tooltip.addAll(this.createTooltip(stack, GearTooltip.itemTooltip()));
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            items.add((Object)this.defaultItem());
        }
    }

    public boolean isDamageable(ItemStack stack) {
        return VaultGearData.read((ItemStack)stack).getState() == VaultGearState.IDENTIFIED;
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)VaultGearData.read((ItemStack)stack).get(ModGearAttributes.DURABILITY, VaultGearAttributeTypeMerger.intSum());
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.equals(Enchantments.f_44986_) || enchantment.equals(Enchantments.f_44982_) || enchantment.equals(EnsorcEnchantments.SOULBOUND.get())) {
            return true;
        }
        return AllowedEnchantmentsData.isAllowedUtilityEnchantment(enchantment);
    }
}

