/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.items.gear;

import com.google.common.collect.Multimap;
import iskallia.vault.VaultMod;
import iskallia.vault.dynamodel.DynamicModel;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.event.PlayerActiveFlags;
import iskallia.vault.gear.VaultGearClassification;
import iskallia.vault.gear.VaultGearHelper;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.VaultGearType;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.crafting.ProficiencyType;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.tooltip.GearTooltip;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ShockedParticleMessage;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.world.data.DiscoveredModelsData;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import xyz.iwolfking.woldsvaults.compat.bettertridents.BetterThrownTrident;
import xyz.iwolfking.woldsvaults.data.enchantments.AllowedEnchantmentsData;
import xyz.iwolfking.woldsvaults.init.ModGearAttributes;
import xyz.iwolfking.woldsvaults.init.ModItems;
import xyz.iwolfking.woldsvaults.models.Tridents;

public class VaultTridentItem
extends TridentItem
implements VaultGearItem,
DyeableLeatherItem {
    public VaultTridentItem(ResourceLocation id, Item.Properties builder) {
        super(builder);
        this.setRegistryName(id);
    }

    @Nullable
    public ResourceLocation getRandomModel(ItemStack stack, Random random, @Nullable Player player, @Nullable DiscoveredModelsData discoveredModelsData) {
        VaultGearData gearData = VaultGearData.read((ItemStack)stack);
        EquipmentSlot intendedSlot = this.getGearType(stack).getEquipmentSlot();
        return ModConfigs.GEAR_MODEL_ROLL_RARITIES.getRandomRoll(stack, gearData, intendedSlot, random, player, discoveredModelsData);
    }

    public Optional<? extends DynamicModel<?>> resolveDynamicModel(ItemStack stack, ResourceLocation key) {
        return Tridents.REGISTRY.get(key);
    }

    @Nullable
    public EquipmentSlot getIntendedSlot(ItemStack stack) {
        return EquipmentSlot.MAINHAND;
    }

    @NotNull
    public VaultGearClassification getClassification(ItemStack stack) {
        return VaultGearClassification.AXE;
    }

    @Nonnull
    public ProficiencyType getCraftingProficiencyType(ItemStack stack) {
        return ProficiencyType.AXE;
    }

    @NotNull
    public VaultGearType getGearType(ItemStack itemStack) {
        return VaultGearType.AXE;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return 1.0f;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.equals(Enchantments.f_44955_) || enchantment.equals(Enchantments.f_44957_) || enchantment.equals(Enchantments.f_44958_)) {
            return false;
        }
        if (enchantment.equals(Enchantments.f_44982_) || AllowedEnchantmentsData.isAllowedUtilityEnchantment(enchantment)) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return VaultGearHelper.getModifiers((ItemStack)stack, (EquipmentSlot)slot);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return VaultGearHelper.shouldPlayGearReequipAnimation((ItemStack)oldStack, (ItemStack)newStack, (boolean)slotChanged);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            items.add((Object)this.defaultItem());
        }
    }

    public int getDefaultTooltipHideFlags(@NotNull ItemStack stack) {
        return super.getDefaultTooltipHideFlags(stack) | ItemStack.TooltipPart.MODIFIERS.m_41809_();
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean m_41475_() {
        return true;
    }

    public boolean isDamageable(ItemStack stack) {
        return VaultGearData.read((ItemStack)stack).getState() == VaultGearState.IDENTIFIED;
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)VaultGearData.read((ItemStack)stack).get(iskallia.vault.init.ModGearAttributes.DURABILITY, VaultGearAttributeTypeMerger.intSum());
    }

    public Component m_7626_(ItemStack stack) {
        return VaultGearHelper.getDisplayName((ItemStack)stack, (Component)super.m_7626_(stack));
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int duration) {
        Player player;
        VaultGearData data = VaultGearData.read((ItemStack)stack);
        if (entity instanceof Player) {
            player = (Player)entity;
            if (data.getItemLevel() > SidedHelper.getVaultLevel((Player)player)) {
                return;
            }
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            float percentDecrease = ((Float)data.get(ModGearAttributes.TRIDENT_WINDUP, VaultGearAttributeTypeMerger.floatSum())).floatValue();
            int i = this.m_8105_(stack) - duration;
            if ((float)i >= 10.0f * (1.0f - percentDecrease)) {
                int j = (Integer)data.get(ModGearAttributes.TRIDENT_RIPTIDE, VaultGearAttributeTypeMerger.intSum());
                if (!level.f_46443_) {
                    stack.m_41622_(1, (LivingEntity)player, p_43388_ -> p_43388_.m_21190_(entity.m_7655_()));
                    if (j == 0) {
                        BetterThrownTrident throwntrident = LoadingModList.get().getModFileById("bettertridents") != null ? new BetterThrownTrident(level, player, stack) : new ThrownTrident(level, (LivingEntity)player, stack);
                        throwntrident.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.5f + (float)j * 0.5f, 1.0f);
                        if (player.m_150110_().f_35937_) {
                            throwntrident.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        level.m_7967_((Entity)throwntrident);
                        level.m_6269_(null, (Entity)throwntrident, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (!player.m_150110_().f_35937_) {
                            player.m_150109_().m_36057_(stack);
                        }
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (j > 0) {
                    float f7 = player.m_146908_();
                    float f = player.m_146909_();
                    float f1 = -Mth.m_14031_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                    float f2 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
                    float f3 = Mth.m_14089_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                    float f4 = Mth.m_14116_((float)(f1 * f1 + f2 * f2 + f3 * f3));
                    float f5 = 3.0f * ((1.0f + (float)j) / 4.0f);
                    player.m_5997_((double)(f1 *= f5 / f4), (double)(f2 *= f5 / f4), (double)(f3 *= f5 / f4));
                    player.m_204079_(20);
                    if (player.m_20096_()) {
                        float f6 = 1.1999999f;
                        player.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                    }
                    SoundEvent soundevent = j >= 3 ? SoundEvents.f_12519_ : (j == 2 ? SoundEvents.f_12518_ : SoundEvents.f_12517_);
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer sPlayer = (ServerPlayer)entity;
                        sPlayer.m_36335_().m_41524_((Item)ModItems.TRIDENT, Math.max((int)(100.0f - 100.0f * percentDecrease), 20));
                    }
                    level.m_6269_(null, (Entity)player, soundevent, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        return VaultGearHelper.rightClick((Level)world, (Player)player, (InteractionHand)hand, (InteractionResultHolder)super.m_7203_(world, player, hand));
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.vaultGearTick(stack, player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        tooltip.addAll(this.createTooltip(stack, GearTooltip.itemTooltip()));
    }

    public static boolean isVaultTridentChanneling(ItemStack stack) {
        VaultGearData data = VaultGearData.read((ItemStack)stack);
        return (Boolean)data.get(ModGearAttributes.TRIDENT_CHANNELING, VaultGearAttributeTypeMerger.anyTrue());
    }

    public static boolean isVaultTridentRiptide(ItemStack stack) {
        VaultGearData data = VaultGearData.read((ItemStack)stack);
        return (Integer)data.get(ModGearAttributes.TRIDENT_RIPTIDE, VaultGearAttributeTypeMerger.intSum()) >= 1;
    }

    public static boolean shouldTriggerChanneling(VaultGearData data) {
        float channelChance = ((Float)data.get(ModGearAttributes.CHANNELING_CHANCE, VaultGearAttributeTypeMerger.floatSum())).floatValue();
        return channelChance >= random.nextFloat();
    }

    public static void triggerChannelingRiptide(ItemStack stack, Level level, Player player) {
        VaultGearData data = VaultGearData.read((ItemStack)stack);
        if (level instanceof ServerLevel && VaultTridentItem.isVaultTridentChanneling(stack) && VaultTridentItem.shouldTriggerChanneling(data)) {
            List nearby = EntityHelper.getNearby((LevelAccessor)level, (Vec3i)player.m_142538_(), (float)5.0f, Mob.class);
            nearby.remove(player);
            nearby.removeIf(mob -> mob instanceof EternalEntity || mob instanceof PetEntity);
            nearby.forEach(mob -> {
                EntityHelper.knockbackIgnoreResist((LivingEntity)mob, (LivingEntity)player, (float)1.0f);
                PlayerActiveFlags.set((Player)player, (PlayerActiveFlags.Flag)PlayerActiveFlags.Flag.ATTACK_AOE, (int)2);
                int ticksSinceLastSwing = player.f_20922_;
                player.f_20922_ = (int)(1.0 / player.m_21133_(Attributes.f_22283_) * 20.0) + 1;
                player.m_5706_((Entity)mob);
                player.f_20922_ = ticksSinceLastSwing;
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ShockedParticleMessage(new Vec3(mob.m_20182_().f_82479_, mob.m_20182_().f_82480_ + (double)(mob.m_20206_() / 2.0f), mob.m_20182_().f_82481_), new Vec3((double)(mob.m_20205_() / 2.0f), (double)(mob.m_20206_() / 2.0f), (double)(mob.m_20205_() / 2.0f)), mob.m_142049_()));
            });
        }
    }

    public static double getTridentScaledDamage(AttributeSnapshot snapshot, LivingEntity entity, double originalDamage) {
        MobType type = entity.m_6336_();
        float increasedDamage = 0.0f;
        if (!ActiveFlags.IS_AP_ATTACKING.isSet()) {
            increasedDamage += ((Float)snapshot.getAttributeValue(iskallia.vault.init.ModGearAttributes.DAMAGE_INCREASE, VaultGearAttributeTypeMerger.floatSum())).floatValue();
        }
        if (type == MobType.f_21641_) {
            increasedDamage += ((Float)snapshot.getAttributeValue(iskallia.vault.init.ModGearAttributes.DAMAGE_UNDEAD, VaultGearAttributeTypeMerger.floatSum())).floatValue();
        }
        if (type == MobType.f_21642_) {
            increasedDamage += ((Float)snapshot.getAttributeValue(iskallia.vault.init.ModGearAttributes.DAMAGE_SPIDERS, VaultGearAttributeTypeMerger.floatSum())).floatValue();
        }
        if (type == MobType.f_21643_) {
            increasedDamage += ((Float)snapshot.getAttributeValue(iskallia.vault.init.ModGearAttributes.DAMAGE_ILLAGERS, VaultGearAttributeTypeMerger.floatSum())).floatValue();
        }
        if (ModConfigs.ENTITY_GROUPS.isInGroup(VaultMod.id((String)"mob_type/nether"), (Entity)entity)) {
            increasedDamage += ((Float)snapshot.getAttributeValue(iskallia.vault.init.ModGearAttributes.DAMAGE_NETHER, VaultGearAttributeTypeMerger.floatSum())).floatValue();
        }
        if (ModConfigs.ENTITY_GROUPS.isInGroup(VaultMod.id((String)"mob_type/champion"), (Entity)entity)) {
            increasedDamage += ((Float)snapshot.getAttributeValue(iskallia.vault.init.ModGearAttributes.DAMAGE_CHAMPION, VaultGearAttributeTypeMerger.floatSum())).floatValue();
        }
        if (ModConfigs.ENTITY_GROUPS.isInGroup(VaultMod.id((String)"mob_type/dungeon"), (Entity)entity)) {
            increasedDamage += ((Float)snapshot.getAttributeValue(iskallia.vault.init.ModGearAttributes.DAMAGE_DUNGEON, VaultGearAttributeTypeMerger.floatSum())).floatValue();
        }
        if (ModConfigs.ENTITY_GROUPS.isInGroup(VaultMod.id((String)"mob_type/tank"), (Entity)entity)) {
            increasedDamage += ((Float)snapshot.getAttributeValue(iskallia.vault.init.ModGearAttributes.DAMAGE_TANK, VaultGearAttributeTypeMerger.floatSum())).floatValue();
        }
        if (ModConfigs.ENTITY_GROUPS.isInGroup(VaultMod.id((String)"mob_type/horde"), (Entity)entity)) {
            increasedDamage += ((Float)snapshot.getAttributeValue(iskallia.vault.init.ModGearAttributes.DAMAGE_HORDE, VaultGearAttributeTypeMerger.floatSum())).floatValue();
        }
        if (ModConfigs.ENTITY_GROUPS.isInGroup(VaultMod.id((String)"mob_type/assassin"), (Entity)entity)) {
            increasedDamage += ((Float)snapshot.getAttributeValue(iskallia.vault.init.ModGearAttributes.DAMAGE_ASSASSIN, VaultGearAttributeTypeMerger.floatSum())).floatValue();
        }
        if (ModConfigs.ENTITY_GROUPS.isInGroup(VaultMod.id((String)"mob_type/dweller"), (Entity)entity)) {
            increasedDamage += ((Float)snapshot.getAttributeValue(iskallia.vault.init.ModGearAttributes.DAMAGE_DWELLER, VaultGearAttributeTypeMerger.floatSum())).floatValue();
        }
        return originalDamage * (double)(1.0f + increasedDamage);
    }
}

