/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.lib;

import iskallia.vault.VaultMod;
import iskallia.vault.gear.data.GearDataCache;
import iskallia.vault.init.ModGearAttributes;
import java.util.Arrays;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public enum ExtendedToolType {
    NONE("none", new ExtendedToolType[0]),
    RAKER("raker", new ExtendedToolType[0]),
    RAVAGER("ravager", new ExtendedToolType[0]);

    private final String id;
    private final String description;
    private final ExtendedToolType[] parents;
    private final int packed;

    private ExtendedToolType(String id, ExtendedToolType ... parents) {
        this.id = id;
        this.description = Util.m_137492_((String)"item", (ResourceLocation)VaultMod.id((String)("tool." + id)));
        this.parents = parents;
        this.packed = parents.length == 0 ? 1 << this.ordinal() : Arrays.stream(this.parents).mapToInt(value -> 1 << value.ordinal()).sum();
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public ExtendedToolType[] getParents() {
        return this.parents;
    }

    public int getPacked() {
        return this.packed;
    }

    @Nullable
    public static ExtendedToolType of(ItemStack stack) {
        GearDataCache data = GearDataCache.of((ItemStack)stack);
        boolean picking = data.hasAttribute(ModGearAttributes.PICKING);
        boolean axing = data.hasAttribute(ModGearAttributes.AXING);
        boolean shoveling = data.hasAttribute(ModGearAttributes.SHOVELLING);
        boolean reaping = data.hasAttribute(ModGearAttributes.REAPING);
        boolean hammering = data.hasAttribute(ModGearAttributes.HAMMERING);
        if (!(picking || axing || shoveling || reaping || hammering)) {
            return NONE;
        }
        if (hammering && reaping && (axing || picking || shoveling)) {
            return RAVAGER;
        }
        if (hammering && reaping) {
            return RAKER;
        }
        return null;
    }

    public boolean has(ExtendedToolType type) {
        return this == type || Arrays.stream(this.parents).anyMatch(toolType -> toolType == type);
    }
}

