/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.lib.vaultarhud;

import io.iridium.vaultarhud.util.Point;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import xyz.iwolfking.woldsvaults.api.util.ConditionalModUtils;
import xyz.iwolfking.woldsvaults.init.ModVaultarHudScreenRegistry;
import xyz.iwolfking.woldsvaults.lib.vaultarhud.screens.RefinedStorageScreens;
import xyz.iwolfking.woldsvaults.lib.vaultarhud.screens.SophisticatedBackpacksScreens;
import xyz.iwolfking.woldsvaults.lib.vaultarhud.screens.VanillaScreens;

public class WoldScreenValidator {
    public static boolean isValidScreen(Screen screen) {
        return WoldScreenValidator.isScreenInList(screen, ModVaultarHudScreenRegistry.getScreens());
    }

    public static boolean isScreenInList(Screen screen, List<Class<? extends Screen>> screenList) {
        return screenList.stream().anyMatch(cls -> cls.isInstance(screen));
    }

    public static Point getScreenHUDCoordinates(Screen screen, Point offset) {
        int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int screenHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        double x = 0.0;
        double y = 0.0;
        if (WoldScreenValidator.isScreenInList(screen, VanillaScreens.SCREENS)) {
            x = (double)((screenWidth - 176) / 2) - offset.getX();
            y = (double)((screenHeight + 166) / 2) - offset.getY();
        }
        if (ConditionalModUtils.isModPresent("sophisticatedbackpacks") && WoldScreenValidator.isScreenInList(screen, SophisticatedBackpacksScreens.SCREENS)) {
            AbstractContainerScreen gs = (AbstractContainerScreen)screen;
            x = (double)((screenWidth - 176) / 2) - offset.getX();
            y = (double)((screenHeight + gs.getYSize()) / 2) - offset.getY();
        } else if (ConditionalModUtils.isModPresent("refinedstorage") && WoldScreenValidator.isScreenInList(screen, RefinedStorageScreens.SCREENS)) {
            AbstractContainerScreen gs = (AbstractContainerScreen)screen;
            x = (double)((screenWidth - gs.getXSize()) / 2) - offset.getX();
            y = (double)((screenHeight + gs.getYSize()) / 2) - offset.getY() - 1.0;
        } else {
            AbstractContainerScreen gs = (AbstractContainerScreen)screen;
            x = (double)((screenWidth - gs.getXSize()) / 2) - offset.getX();
            y = (double)((screenHeight + gs.getYSize()) / 2) - offset.getY();
        }
        return new Point(x, y);
    }
}

