/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.ensorcellation;

import cofh.ensorcellation.enchantment.VitalityEnchantment;
import cofh.ensorcellation.event.CommonEvents;
import cofh.ensorcellation.init.EnsorcEnchantments;
import cofh.lib.util.Constants;
import cofh.lib.util.Utils;
import iskallia.vault.block.VaultChestBlock;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Restriction(require={@Condition(type=Condition.Type.MOD, value="ensorcellation")})
@Mixin(value={CommonEvents.class}, remap=false)
public class MixinCommonEvents {
    @Overwrite
    @SubscribeEvent
    public static void handleLivingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        LivingEntity entity = event.getEntityLiving();
        int encVitality = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)entity, (Enchantment)((Enchantment)EnsorcEnchantments.VITALITY.get()));
        AttributeInstance healthAttr = entity.m_21051_(Attributes.f_22276_);
        if (healthAttr != null) {
            healthAttr.m_22120_(Constants.UUID_ENCH_VITALITY_HEALTH);
            if (encVitality > 0) {
                healthAttr.m_22118_(new AttributeModifier(Constants.UUID_ENCH_VITALITY_HEALTH, "vitality", (double)(Math.min(encVitality, 3) * VitalityEnchantment.health), AttributeModifier.Operation.ADDITION));
            }
        }
    }

    @Overwrite
    @SubscribeEvent
    public static void handleLivingExperienceDropEvent(LivingExperienceDropEvent event) {
        int encFool;
        Player player;
        if (!event.isCanceled() && (player = event.getAttackingPlayer()) != null && (encFool = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)player, (Enchantment)((Enchantment)EnsorcEnchantments.CURSE_FOOL.get()))) > 0) {
            event.setDroppedExperience(0);
            event.setCanceled(true);
        }
    }

    @Overwrite
    @SubscribeEvent
    public static void handleBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
        Player player;
        int encAirAffinity;
        if (!event.isCanceled() && (encAirAffinity = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)(player = event.getPlayer()), (Enchantment)((Enchantment)EnsorcEnchantments.AIR_AFFINITY.get()))) > 0 && !player.m_20096_()) {
            if (event.getState().m_60734_() instanceof VaultChestBlock) {
                return;
            }
            event.setNewSpeed(Math.max(event.getNewSpeed(), event.getOriginalSpeed() * 5.0f));
        }
    }
}

