/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.pnc;

import com.google.common.collect.ImmutableMap;
import iskallia.vault.init.ModItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.recipes.machine.PressureChamberRecipeImpl;
import me.desht.pneumaticcraft.common.recipes.machine.PressureDisenchantingRecipe;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Restriction(require={@Condition(type=Condition.Type.MOD, value="pneumaticcraft")})
@Mixin(value={PressureDisenchantingRecipe.class}, remap=false)
public abstract class MixinDisenchantingPressureRecipe
extends PressureChamberRecipeImpl {
    @Shadow
    protected abstract boolean blacklisted(ItemStack var1);

    public MixinDisenchantingPressureRecipe(ResourceLocation id, List<Ingredient> inputs, float pressureRequired, ItemStack ... outputs) {
        super(id, inputs, pressureRequired, outputs);
    }

    @Overwrite
    public Collection<Integer> findIngredients(@Nonnull IItemHandler chamberHandler) {
        int bookSlot = -1;
        int itemSlot = -1;
        int pogSlot = -1;
        for (int i = 0; i < chamberHandler.getSlots(); ++i) {
            ItemStack stack = chamberHandler.getStackInSlot(i);
            if (stack.m_41720_() == ModItems.ECHO_POG) {
                pogSlot = i;
            }
            if (stack.m_41720_() == Items.f_42517_) {
                bookSlot = i;
            } else {
                int minEnchantments;
                int n = minEnchantments = stack.m_41720_() == Items.f_42690_ ? 2 : 1;
                if (!this.blacklisted(stack) && EnchantmentHelper.m_44831_((ItemStack)stack).size() >= minEnchantments) {
                    itemSlot = i;
                }
            }
            if (bookSlot < 0 || itemSlot < 0 || pogSlot < 0) continue;
            return List.of(Integer.valueOf(bookSlot), Integer.valueOf(itemSlot), Integer.valueOf(pogSlot));
        }
        return Collections.emptyList();
    }

    @Overwrite
    public NonNullList<ItemStack> craftRecipe(@Nonnull IItemHandler chamberHandler, List<Integer> ingredientSlots, boolean simulate) {
        ItemStack book = chamberHandler.extractItem(ingredientSlots.get(0).intValue(), 1, simulate);
        ItemStack enchantedStack = chamberHandler.extractItem(ingredientSlots.get(1).intValue(), 1, simulate);
        ItemStack pog = chamberHandler.extractItem(ingredientSlots.get(2).intValue(), 1, simulate);
        if (!(book.m_41619_() || enchantedStack.m_41619_() || pog.m_41619_())) {
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)enchantedStack);
            ArrayList l = new ArrayList(enchantments.keySet());
            Enchantment strippedEnchantment = (Enchantment)l.get(ThreadLocalRandom.current().nextInt(l.size()));
            int level = (Integer)enchantments.get(strippedEnchantment);
            enchantments.remove(strippedEnchantment);
            if (enchantedStack.m_41720_() == Items.f_42690_) {
                enchantedStack = new ItemStack((ItemLike)Items.f_42690_);
            }
            EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)enchantedStack);
            ItemStack enchantedBook = new ItemStack((ItemLike)Items.f_42690_);
            EnchantmentHelper.m_44865_((Map)ImmutableMap.of((Object)strippedEnchantment, (Object)level), (ItemStack)enchantedBook);
            return NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{enchantedBook, enchantedStack});
        }
        return NonNullList.m_122779_();
    }

    @Overwrite
    public List<Ingredient> getInputsForDisplay() {
        ItemStack pick = new ItemStack((ItemLike)Items.f_42390_);
        pick.m_41663_(Enchantments.f_44987_, 1);
        ItemStack enchantedBook = new ItemStack((ItemLike)Items.f_42690_);
        enchantedBook.m_41663_(Enchantments.f_44987_, 1);
        enchantedBook.m_41663_(Enchantments.f_44984_, 1);
        return List.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{pick, enchantedBook}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42517_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.ECHO_POG}));
    }

    @Overwrite
    public List<List<ItemStack>> getResultsForDisplay() {
        ItemStack pick = new ItemStack((ItemLike)Items.f_42390_);
        ItemStack enchantedBook = new ItemStack((ItemLike)Items.f_42690_);
        enchantedBook.m_41663_(Enchantments.f_44984_, 1);
        ItemStack resultBook = new ItemStack((ItemLike)Items.f_42690_);
        resultBook.m_41663_(Enchantments.f_44987_, 1);
        return List.of(List.of(pick, enchantedBook), List.of(resultBook));
    }

    @Overwrite
    public boolean isValidInputItem(ItemStack stack) {
        return stack.m_41720_() == ModItems.ECHO_POG || stack.m_41720_() == Items.f_42517_ || stack.m_41720_() != Items.f_42690_ && !EnchantmentHelper.m_44831_((ItemStack)stack).isEmpty();
    }
}

