/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.altar;

import iskallia.vault.altar.RequiredItems;
import iskallia.vault.config.Config;
import iskallia.vault.config.altar.VaultAltarIngredientsConfig;
import iskallia.vault.config.altar.entry.AltarIngredientEntry;
import iskallia.vault.config.entry.LevelEntryMap;
import iskallia.vault.research.ResearchTree;
import iskallia.vault.util.data.WeightedList;
import iskallia.vault.world.data.PlayerResearchesData;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={VaultAltarIngredientsConfig.class}, remap=false)
public class MixinVaultAltarIngredientsConfig {
    @Shadow
    private LevelEntryMap<Map<String, WeightedList<AltarIngredientEntry>>> LEVELS;
    @Unique
    private ServerPlayer woldsVaults$capturedPlayer;
    private static Map<String, String> namespaceToModNameMap = Map.ofEntries(new AbstractMap.SimpleEntry<String, String>("powah", "Powah"), new AbstractMap.SimpleEntry<String, String>("refinedstorage", "Refined Storage"), new AbstractMap.SimpleEntry<String, String>("ae2", "Applied Energistics"), new AbstractMap.SimpleEntry<String, String>("botania", "Botania"), new AbstractMap.SimpleEntry<String, String>("integrateddynamics", "Integrated Dynamics"), new AbstractMap.SimpleEntry<String, String>("mekanism", "Mekanism"), new AbstractMap.SimpleEntry<String, String>("moremekanismprocessing", "Mekanism"), new AbstractMap.SimpleEntry<String, String>("immersiveengineering", "Immersive Engineering"), new AbstractMap.SimpleEntry<String, String>("thermal", "Thermal Expansion"), new AbstractMap.SimpleEntry<String, String>("create", "Create"), new AbstractMap.SimpleEntry<String, String>("occultism", "Occultism"), new AbstractMap.SimpleEntry<String, String>("ars_nouveau", "Ars Nouveau"), new AbstractMap.SimpleEntry<String, String>("createaddition", "Create Crafts and Additions"), new AbstractMap.SimpleEntry<String, String>("industrialforegoing", "Industrial Foregoing"), new AbstractMap.SimpleEntry<String, String>("hostilenetworks", "Hostile Neural Networks"), new AbstractMap.SimpleEntry<String, String>("mysticalagriculture", "Mystical Agriculture"), new AbstractMap.SimpleEntry<String, String>("fluxnetworks", "Flux Networks"), new AbstractMap.SimpleEntry<String, String>("botanicalmachinery", "Botanical Machinery"));

    @Unique
    private Map<String, AltarIngredientEntry> woldsVaults$getEntriesWithModFilter(int vaultLevel, ServerPlayer player) {
        Optional pool = this.LEVELS.getForLevel(vaultLevel);
        if (pool.isEmpty()) {
            throw new IllegalArgumentException("No entry found for the given level: " + vaultLevel);
        }
        Map map = (Map)pool.get();
        HashMap<String, AltarIngredientEntry> recipe = new HashMap<String, AltarIngredientEntry>();
        PlayerResearchesData researchData = PlayerResearchesData.get((ServerLevel)player.m_183503_());
        ResearchTree playerResearchTree = researchData.getResearches((Player)player);
        map.forEach((k, v) -> {
            ArrayList entriesToRemove = new ArrayList();
            v.forEach((altarIngredientEntry, number) -> {
                ArrayList<ItemStack> itemsToRemove = new ArrayList<ItemStack>();
                for (ItemStack itemStack : altarIngredientEntry.getItems()) {
                    if (!namespaceToModNameMap.containsKey(Objects.requireNonNull(itemStack.m_41720_().getRegistryName()).m_135827_())) continue;
                    if (playerResearchTree.isResearched(namespaceToModNameMap.get(itemStack.m_41720_().getRegistryName().m_135827_()))) break;
                    itemsToRemove.add(itemStack);
                }
                altarIngredientEntry.getItems().removeAll(itemsToRemove);
                if (altarIngredientEntry.getItems().isEmpty()) {
                    entriesToRemove.add(altarIngredientEntry);
                }
            });
            entriesToRemove.forEach(arg_0 -> ((WeightedList)v).removeEntry(arg_0));
            recipe.put((String)k, (AltarIngredientEntry)v.getRandom(Config.rand));
        });
        return recipe;
    }

    @Redirect(method={"getIngredients"}, at=@At(value="INVOKE", target="Liskallia/vault/config/altar/VaultAltarIngredientsConfig;getEntries(I)Ljava/util/Map;"))
    private Map<String, AltarIngredientEntry> modifyGetEntries(VaultAltarIngredientsConfig instance, int vaultLevel) {
        return this.woldsVaults$getEntriesWithModFilter(vaultLevel, this.woldsVaults$capturedPlayer);
    }

    @Inject(method={"getIngredients"}, at={@At(value="HEAD")})
    private void getPlayerFromGetIngredients(ServerPlayer player, BlockPos pos, CallbackInfoReturnable<List<RequiredItems>> cir) {
        this.woldsVaults$capturedPlayer = player;
    }
}

