/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.altar;

import iskallia.vault.altar.AltarInfusionRecipe;
import iskallia.vault.block.entity.VaultAltarTileEntity;
import iskallia.vault.world.data.PlayerVaultAltarData;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import xyz.iwolfking.woldsvaults.api.util.PlayerVaultAltarDataHelper;
import xyz.iwolfking.woldsvaults.init.ModItems;

@Mixin(value={VaultAltarTileEntity.class}, remap=false)
public abstract class MixinVaultAltarTileEntity
extends BlockEntity {
    @Shadow
    private UUID owner;
    @Shadow
    private VaultAltarTileEntity.AltarState altarState;
    @Shadow
    private AltarInfusionRecipe recipe;
    @Shadow
    private ItemStack input;

    public MixinVaultAltarTileEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    @Shadow
    protected abstract void updateDisplayedIndex(AltarInfusionRecipe var1);

    @Shadow
    public abstract void setAltarState(VaultAltarTileEntity.AltarState var1);

    @Shadow
    public abstract void sendUpdates();

    @Overwrite
    public InteractionResult onAddInput(ServerPlayer player, ItemStack input) {
        if (this.f_58857_ != null && this.owner.equals(player.m_142081_())) {
            ServerLevel serverLevel = (ServerLevel)this.f_58857_;
            List altarPositions = PlayerVaultAltarData.get((ServerLevel)serverLevel).getAltars(player.m_142081_());
            for (BlockPos altarPosition : altarPositions) {
                VaultAltarTileEntity altar;
                BlockEntity te;
                if (!serverLevel.m_46749_(altarPosition) || !((te = serverLevel.m_7702_(altarPosition)) instanceof VaultAltarTileEntity) || (altar = (VaultAltarTileEntity)te).getAltarState() != VaultAltarTileEntity.AltarState.INFUSING) continue;
                return InteractionResult.FAIL;
            }
            if (input != null && input.m_41720_().equals(ModItems.GREEDY_VAULT_ROCK)) {
                this.recipe = PlayerVaultAltarDataHelper.generateGreedRecipe(player, this.f_58858_, true);
            } else {
                PlayerVaultAltarData altarData = PlayerVaultAltarData.get((ServerLevel)serverLevel);
                this.recipe = altarData.getRecipe(player, this.f_58858_);
            }
            this.updateDisplayedIndex(this.recipe);
            this.setAltarState(VaultAltarTileEntity.AltarState.ACCEPTING);
            this.input = input.m_41777_();
            this.input.m_41764_(1);
            if (!player.m_7500_()) {
                input.m_41774_(1);
            }
            this.sendUpdates();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

