/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.block;

import com.llamalad7.mixinextras.sugar.Local;
import iskallia.vault.block.VaultChestBlock;
import iskallia.vault.block.entity.VaultChestTileEntity;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import xyz.iwolfking.woldsvaults.init.ModGearAttributes;

@ParametersAreNonnullByDefault
@Mixin(value={VaultChestBlock.class}, remap=false)
public class MixinVaultChestBlock
extends ChestBlock {
    public MixinVaultChestBlock(BlockBehaviour.Properties p_51490_, Supplier<BlockEntityType<? extends ChestBlockEntity>> p_51491_) {
        super(p_51490_, p_51491_);
    }

    @Overwrite
    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        VaultChestTileEntity chest;
        VaultChestBlock thisInstance = (VaultChestBlock)this;
        if (te instanceof VaultChestTileEntity && !(chest = (VaultChestTileEntity)te).isVaultChest() && !thisInstance.hasStepBreaking(chest)) {
            super.m_6240_(world, player, pos, state, te, stack);
        } else {
            player.m_36246_(Stats.f_12949_.m_12902_((Object)thisInstance));
            player.m_36399_(0.005f);
            if (te instanceof VaultChestTileEntity) {
                VaultChestTileEntity chest2 = (VaultChestTileEntity)te;
                if (!(stack.m_41720_() instanceof VaultGearItem)) {
                    return;
                }
                VaultGearData data = VaultGearData.read((ItemStack)player.m_21205_().m_41777_());
                if (data == null) {
                    return;
                }
                boolean hasBreach = data.hasAttribute(ModGearAttributes.BREACHING);
                float dismantle_chance = 0.0f;
                dismantle_chance = ((Float)AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player).getAttributeValue(ModGearAttributes.DISMANTLE_CHANCE, VaultGearAttributeTypeMerger.floatSum())).floatValue();
                for (int slot = 0; slot < chest2.m_6643_(); ++slot) {
                    ItemStack invStack = chest2.m_8020_(slot);
                    if (invStack.m_41619_()) continue;
                    Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)invStack);
                    chest2.m_6836_(slot, ItemStack.f_41583_);
                    if (hasBreach) continue;
                    if (dismantle_chance >= 1.0f) {
                        dismantle_chance -= 1.0f;
                        this.m_142387_(world, player, pos, state);
                        continue;
                    }
                    if (!(dismantle_chance > 0.0f) || (double)dismantle_chance < Math.random()) break;
                    this.m_142387_(world, player, pos, state);
                    dismantle_chance = 0.0f;
                }
                if (hasBreach || chest2.m_7983_()) {
                    world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                }
            }
        }
    }

    @Redirect(method={"onDestroyedByPlayer"}, at=@At(value="INVOKE", target="Liskallia/vault/block/VaultChestBlock;hasStepBreaking(Liskallia/vault/block/entity/VaultChestTileEntity;)Z"), remap=false)
    private boolean fixOnDestroyedByPlayer(VaultChestBlock instance, VaultChestTileEntity tileEntity, @Local BlockEntity te) {
        VaultChestTileEntity chest;
        return instance.hasStepBreaking(tileEntity) && te instanceof VaultChestTileEntity && (chest = (VaultChestTileEntity)te).isVaultChest();
    }
}

