/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.compat.ensorcellation;

import iskallia.vault.client.gui.framework.element.EnchanterEnchantSelectorElement;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.item.tool.ToolItem;
import iskallia.vault.util.EnchantmentEntry;
import iskallia.vault.util.function.ObservableSupplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import xyz.iwolfking.woldsvaults.data.enchantments.BannedEnchantmentsData;

@Mixin(value={EnchanterEnchantSelectorElement.EnchanterEnchantSelectorModel.class}, remap=false)
public abstract class MixinEnchanterEnchantSelectorModel {
    @Shadow
    @Final
    private ObservableSupplier<ItemStack> inputSupplier;
    @Shadow
    @Final
    private Supplier<String> searchFilter;

    @Shadow
    public static boolean canCraft(ItemStack gearStack, EnchantmentEntry config) {
        return false;
    }

    @Overwrite
    public List<EnchantmentEntry> getEntries() {
        ItemStack input = (ItemStack)this.inputSupplier.get();
        if (input.m_41619_()) {
            return Collections.emptyList();
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return Collections.emptyList();
        }
        String searchTerm = this.searchFilter.get().toLowerCase(Locale.ROOT);
        Map currentEnchantments = EnchantmentHelper.m_44831_((ItemStack)input);
        ArrayList<EnchantmentEntry> out = new ArrayList<EnchantmentEntry>();
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
            if (enchantment.m_6589_() || !enchantment.m_6081_(input) || (!(input.m_41720_() instanceof VaultGearItem) && !(input.m_41720_() instanceof ToolItem) && !input.m_41720_().getRegistryName().toString().equals("the_vault:tool") ? BannedEnchantmentsData.BANNED_ENCHANT_REGISTRY_NAMES.contains(enchantment.getRegistryName().toString()) && !enchantment.getRegistryName().toString().equals("minecraft:mending") : BannedEnchantmentsData.BANNED_ENCHANT_REGISTRY_NAMES.contains(enchantment.getRegistryName().toString()))) continue;
            String enchantName = new TranslatableComponent(enchantment.m_44704_()).getString();
            if (!enchantName.toLowerCase(Locale.ROOT).contains(searchTerm)) continue;
            out.add(new EnchantmentEntry(enchantment, enchantment.m_6586_()));
        }
        HashMap canCraftLookup = new HashMap();
        out.forEach(enchantmentEntry -> canCraftLookup.put(enchantmentEntry, MixinEnchanterEnchantSelectorModel.canCraft(input, enchantmentEntry)));
        HashMap alreadyHasLookup = new HashMap();
        Comparator<EnchantmentEntry> enchantmentSortComparator = Comparator.comparing(enchantmentEntry -> enchantmentEntry.getEnchantment().getRegistryName().toString(), Comparator.reverseOrder());
        out.forEach(enchantmentEntry -> alreadyHasLookup.put(enchantmentEntry, currentEnchantments.getOrDefault(enchantmentEntry.getEnchantment(), 0) >= enchantmentEntry.getLevel()));
        Comparator<EnchantmentEntry> comparator = Comparator.comparing(o -> o.getEnchantment().getRegistryName().toString());
        out.sort(comparator.reversed());
        out.sort((c1, c2) -> -Boolean.compare((Boolean)canCraftLookup.get(c1), (Boolean)canCraftLookup.get(c2)));
        out.sort((c1, c2) -> Boolean.compare((Boolean)alreadyHasLookup.get(c1), (Boolean)alreadyHasLookup.get(c2)));
        return out;
    }
}

