/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.compat.lightmanscurrency;

import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import iskallia.vault.block.ShopPedestalBlock;
import iskallia.vault.block.entity.ShopPedestalBlockTile;
import iskallia.vault.config.ShopPedestalConfig;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.vault.objective.ParadoxObjective;
import iskallia.vault.event.event.ShopPedestalPriceEvent;
import iskallia.vault.item.CoinBlockItem;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.util.LootInitialization;
import iskallia.vault.world.data.PlayerExpertisesData;
import iskallia.vault.world.data.ServerVaults;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.iwolfking.woldsvaults.api.util.ShopPedestalHelper;
import xyz.iwolfking.woldsvaults.expertises.ShopRerollExpertise;
import xyz.iwolfking.woldsvaults.init.ModEffects;

@Restriction(require={@Condition(type=Condition.Type.MOD, value="lightmanscurrency")})
@Mixin(value={ShopPedestalBlock.class}, remap=false)
public abstract class MixinShopPedestalBlock
extends Block
implements EntityBlock,
GameMasterBlock {
    @Unique
    private static final BooleanProperty REROLLED = BooleanProperty.m_61465_((String)"rerolled");
    @Shadow
    @Final
    public static BooleanProperty ACTIVE;

    public MixinShopPedestalBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=true)
    private void overrideDefaultBlockstate(CallbackInfo ci) {
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)REROLLED, (Comparable)Boolean.valueOf(false)));
    }

    @Overwrite(remap=true)
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof ShopPedestalBlockTile) {
            Optional vaultOpt;
            ShopPedestalBlockTile tile = (ShopPedestalBlockTile)blockEntity;
            if (ServerVaults.get((Level)worldIn).isPresent() && (vaultOpt = ServerVaults.get((Level)worldIn)).isPresent()) {
                Vault vault = (Vault)vaultOpt.get();
                Objective.ObjList objectives = (Objective.ObjList)((Objectives)vault.get(Vault.OBJECTIVES)).get(Objectives.LIST);
                for (Objective obj : objectives) {
                    ParadoxObjective paradoxObjective;
                    if (!(obj instanceof ParadoxObjective) || !((ParadoxObjective.Type)(paradoxObjective = (ParadoxObjective)obj).get(ParadoxObjective.TYPE)).equals((Object)ParadoxObjective.Type.BUILD)) continue;
                    return InteractionResult.FAIL;
                }
            }
            if (tile.isInitialized() && player.m_6144_()) {
                Vault vault;
                if (((Boolean)state.m_61143_((Property)REROLLED)).booleanValue() || player.m_21023_(ModEffects.REROLLED_TIMEOUT)) {
                    return InteractionResult.FAIL;
                }
                if (!worldIn.f_46443_ && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ExpertiseTree expertises = PlayerExpertisesData.get((ServerLevel)serverPlayer.m_183503_()).getExpertises(player);
                    boolean hasExpertise = false;
                    Iterator iterator = expertises.getAll(ShopRerollExpertise.class, Skill::isUnlocked).iterator();
                    if (iterator.hasNext()) {
                        ShopRerollExpertise expertise = (ShopRerollExpertise)((Object)iterator.next());
                        hasExpertise = true;
                    }
                    if (!hasExpertise) {
                        return InteractionResult.FAIL;
                    }
                }
                if ((vault = (Vault)ServerVaults.get((Level)worldIn).orElse(null)) == null) {
                    return InteractionResult.FAIL;
                }
                ShopPedestalConfig.ShopOffer offer = ShopPedestalHelper.generatePedestalOffer(state, worldIn, (RandomSource)JavaRandom.ofNanoTime());
                if (offer != null && !offer.isEmpty()) {
                    ItemStack stack = LootInitialization.initializeVaultLoot((ItemStack)offer.offer(), (Vault)vault, (BlockPos)pos, (RandomSource)JavaRandom.ofNanoTime());
                    tile.setOffer(stack, OverSizedItemStack.of((ItemStack)offer.currency().overSizedStack()));
                }
                if (!worldIn.f_46443_) {
                    worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)REROLLED, (Comparable)Boolean.valueOf(true)), 3);
                }
                tile.setInitialized(true);
                tile.m_6596_();
                worldIn.m_7260_(pos, state, (BlockState)state.m_61124_((Property)REROLLED, (Comparable)Boolean.valueOf(true)), 3);
                if (!worldIn.f_46443_ && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ExpertiseTree expertises = PlayerExpertisesData.get((ServerLevel)serverPlayer.m_183503_()).getExpertises(player);
                    int rerollTimeout = 0;
                    for (ShopRerollExpertise expertise : expertises.getAll(ShopRerollExpertise.class, Skill::isUnlocked)) {
                        rerollTimeout += expertise.getRerollTimeout();
                    }
                    player.m_7292_(new MobEffectInstance(ModEffects.REROLLED_TIMEOUT, rerollTimeout));
                }
            } else if (tile.isInitialized()) {
                ItemStack c = tile.getOfferStack();
                if (!c.m_41619_()) {
                    ShopPedestalPriceEvent event = new ShopPedestalPriceEvent(player, c, tile.getCurrencyStack());
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    ItemStack currency = event.getCost();
                    return player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(itemHandler -> {
                        List allItems = List.of();
                        if (!player.m_7500_()) {
                            allItems = InventoryUtil.findAllItems((Player)player);
                            if (!(currency.m_41720_() instanceof CoinBlockItem)) {
                                if (!MixinShopPedestalBlock.hasEnoughCurrency(allItems, currency)) {
                                    if (worldIn.f_46443_) {
                                        player.m_5661_((Component)new TranslatableComponent("message.the_vault.shop_pedestal.fail", new Object[]{currency.m_41786_()}), true);
                                    }
                                    return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
                                }
                            } else if (!this.woldsVaults$lightmansCurrencyExtract(player, currency)) {
                                if (worldIn.f_46443_) {
                                    player.m_5661_((Component)new TranslatableComponent("message.the_vault.shop_pedestal.fail", new Object[]{currency.m_41786_()}), true);
                                }
                                return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
                            }
                        }
                        if (!worldIn.f_46443_) {
                            if (!player.m_7500_()) {
                                if (!(currency.m_41720_() instanceof CoinBlockItem)) {
                                    MixinShopPedestalBlock.deductItems(allItems, currency.m_41613_(), currency);
                                }
                                BlockState inactiveState = (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
                                tile.m_7651_();
                                worldIn.m_46597_(pos, inactiveState);
                            }
                            MixinShopPedestalBlock.m_49840_((Level)worldIn, (BlockPos)player.m_20097_().m_7494_(), (ItemStack)c.m_41777_());
                            worldIn.m_5594_(null, pos, SoundEvents.f_144049_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        } else {
                            if (!player.m_150110_().f_35937_) {
                                tile.m_7651_();
                            }
                            player.m_5661_((Component)new TranslatableComponent("message.the_vault.shop_pedestal.purchase", new Object[]{c.m_41613_(), c.m_41786_(), currency.m_41613_(), currency.m_41786_()}), true);
                        }
                        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
                    }).orElse(InteractionResult.PASS);
                }
                return InteractionResult.PASS;
            }
        }
        if (player.m_150110_().f_35937_) {
            ItemStack o = player.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack c = player.m_21120_(InteractionHand.OFF_HAND);
            if (!c.m_41619_() && !o.m_41619_()) {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
                BlockEntity blockEntity2 = worldIn.m_7702_(pos);
                if (blockEntity2 instanceof ShopPedestalBlockTile) {
                    ShopPedestalBlockTile tile = (ShopPedestalBlockTile)blockEntity2;
                    tile.setOffer(o.m_41777_(), OverSizedItemStack.of((ItemStack)c.m_41777_()));
                    tile.m_6596_();
                    return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
                }
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
        }
        return InteractionResult.PASS;
    }

    @Unique
    private boolean woldsVaults$lightmansCurrencyExtract(Player player, ItemStack costStack) {
        CoinValue cValue = CoinValue.fromItemOrValue((Item)costStack.m_41720_(), (int)costStack.m_41613_(), (long)81L);
        return MoneyUtil.ProcessPayment((Container)player.m_150109_(), (Player)player, (CoinValue)cValue);
    }

    private static boolean hasEnoughCurrency(List<InventoryUtil.ItemAccess> allItems, ItemStack currency) {
        int priceValue = currency.m_41613_();
        for (InventoryUtil.ItemAccess itemAccess : allItems) {
            if (itemAccess.getStack().m_41720_().equals(currency.m_41720_())) {
                priceValue -= itemAccess.getStack().m_41613_();
            }
            if (priceValue > 0) continue;
            return true;
        }
        return false;
    }

    private static int deductItems(List<InventoryUtil.ItemAccess> allItems, int priceValue, ItemStack currencyStack) {
        for (InventoryUtil.ItemAccess itemAccess : allItems) {
            int countToRemove;
            ItemStack stack = itemAccess.getStack();
            if (stack.m_41720_() != currencyStack.m_41720_() || (countToRemove = Math.min(priceValue, stack.m_41613_())) <= 0) continue;
            itemAccess.setStack(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - countToRemove)));
            if ((priceValue -= countToRemove) > 0) continue;
            break;
        }
        return priceValue;
    }

    @Inject(method={"createBlockStateDefinition"}, at={@At(value="TAIL")}, remap=true)
    protected void addRerolledState(StateDefinition.Builder<Block, BlockState> pBuilder, CallbackInfo ci) {
        pBuilder.m_61104_(new Property[]{REROLLED});
    }
}

