/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.custom;

import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.gear.VaultGearModifierHelper;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.modification.GearModification;
import java.util.Random;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import xyz.iwolfking.woldsvaults.init.ModGearAttributes;
import xyz.iwolfking.woldsvaults.items.gear.VaultMapItem;
import xyz.iwolfking.woldsvaults.models.Maps;

@Mixin(value={VaultGearModifierHelper.class}, remap=false)
public class MixinCorruptGearModification {
    @Overwrite
    public static GearModification.Result setGearCorrupted(ItemStack stack) {
        VaultGearData data = VaultGearData.read((ItemStack)stack);
        if (!data.isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        if (stack.m_41720_() instanceof VaultMapItem && JavaRandom.ofNanoTime().nextFloat() <= 0.1f) {
            VaultGearModifier objModifier = null;
            VaultGearModifier themeModifier = null;
            for (VaultGearModifier mod : data.getModifiers(VaultGearModifier.AffixType.IMPLICIT)) {
                if (mod.getAttribute().equals(ModGearAttributes.OBJECTIVE)) {
                    objModifier = mod;
                    continue;
                }
                if (!mod.getAttribute().equals(ModGearAttributes.THEME_POOL)) continue;
                themeModifier = mod;
            }
            if (objModifier != null) {
                data.removeModifier(objModifier);
            }
            if (themeModifier != null) {
                data.removeModifier(themeModifier);
            }
            data.addModifier(VaultGearModifier.AffixType.IMPLICIT, new VaultGearModifier(ModGearAttributes.OBJECTIVE, (Object)"corrupted"));
            data.addModifier(VaultGearModifier.AffixType.IMPLICIT, new VaultGearModifier(ModGearAttributes.THEME_POOL, (Object)"the_vault:corrupted"));
            data.createOrReplaceAttributeValue(ModGearAttributes.DIVINE, (Object)false);
            data.createOrReplaceAttributeValue(iskallia.vault.init.ModGearAttributes.IS_CORRUPTED, (Object)true);
            data.createOrReplaceAttributeValue(iskallia.vault.init.ModGearAttributes.GEAR_MODEL, (Object)Maps.CORRUPTED_MAP.getId());
            data.write(stack);
            return GearModification.Result.makeSuccess();
        }
        if (data.hasAttribute(ModGearAttributes.DIVINE)) {
            Random random = new Random();
            if (random.nextFloat() <= 0.75f) {
                data.createOrReplaceAttributeValue(ModGearAttributes.DIVINE, (Object)false);
                data.write(stack);
            }
            return GearModification.Result.makeSuccess();
        }
        data.createOrReplaceAttributeValue(iskallia.vault.init.ModGearAttributes.IS_CORRUPTED, (Object)true);
        data.write(stack);
        return GearModification.Result.makeSuccess();
    }
}

