/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.custom;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.EntityChainAttackedEvent;
import iskallia.vault.core.event.common.EntityDamageBlockEvent;
import iskallia.vault.dynamodel.registry.DynamicModelRegistry;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.event.GearAttributeEvents;
import iskallia.vault.event.PlayerActiveFlags;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ChainingParticleMessage;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.Entropy;
import iskallia.vault.util.calc.BlockChanceHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.iwolfking.woldsvaults.init.ModEffects;
import xyz.iwolfking.woldsvaults.init.ModGearAttributes;
import xyz.iwolfking.woldsvaults.init.ModSounds;
import xyz.iwolfking.woldsvaults.mixins.LivingEntityAccessor;

@Mixin(value={GearAttributeEvents.class}, remap=false)
public class MixinGearAttributeEvents {
    @Redirect(method={"lambda$triggerEffectCloudsActive$18"}, at=@At(value="INVOKE", target="Liskallia/vault/util/Entropy;canExecute(Lnet/minecraft/world/entity/Entity;Liskallia/vault/util/Entropy$Stat;F)Z"))
    private static boolean addEffectCloudChanceFromAttributeActive(Entity entity, Entropy.Stat stat, float chance) {
        LivingEntity living;
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity) instanceof Player) {
            float increasedEffectCloudChance = ((Float)AttributeSnapshotHelper.getInstance().getSnapshot(living).getAttributeValue(ModGearAttributes.INCREASED_EFFECT_CLOUD_CHANCE, VaultGearAttributeTypeMerger.floatSum())).floatValue();
            return Entropy.canExecute((Entity)entity, (Entropy.Stat)stat, (float)(chance + increasedEffectCloudChance));
        }
        return Entropy.canExecute((Entity)entity, (Entropy.Stat)stat, (float)chance);
    }

    @Redirect(method={"lambda$triggerEffectCloudsPassive$19"}, at=@At(value="INVOKE", target="Liskallia/vault/util/Entropy;canExecute(Lnet/minecraft/world/entity/Entity;Liskallia/vault/util/Entropy$Stat;F)Z"))
    private static boolean addEffectCloudChanceFromAttributePassive(Entity entity, Entropy.Stat stat, float chance) {
        LivingEntity living;
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity) instanceof Player) {
            float increasedEffectCloudChance = ((Float)AttributeSnapshotHelper.getInstance().getSnapshot(living).getAttributeValue(ModGearAttributes.INCREASED_EFFECT_CLOUD_CHANCE, VaultGearAttributeTypeMerger.floatSum())).floatValue();
            return Entropy.canExecute((Entity)entity, (Entropy.Stat)stat, (float)(chance + increasedEffectCloudChance));
        }
        return Entropy.canExecute((Entity)entity, (Entropy.Stat)stat, (float)chance);
    }

    @SubscribeEvent
    @Overwrite
    public static void blockAttack(LivingAttackEvent event) {
        LivingEntity attacked = event.getEntityLiving();
        DamageSource damageSource = event.getSource();
        if (!attacked.m_183503_().m_5776_() && !damageSource.m_19378_()) {
            float blockChance = 0.0f;
            if (AttributeSnapshotHelper.canHaveSnapshot((LivingEntity)attacked)) {
                blockChance = BlockChanceHelper.getBlockChance((LivingEntity)attacked);
            }
            if (attacked.m_21023_(ModEffects.SAFER_SPACE)) {
                MobEffectInstance currentSpace = attacked.m_21124_(ModEffects.SAFER_SPACE);
                int currentAmp = currentSpace.m_19564_();
                if (currentAmp >= 255) {
                    CommonEvents.ENTITY_DAMAGE_BLOCK.invoke((Object)new EntityDamageBlockEvent.Data(true, damageSource, attacked));
                } else {
                    event.setCanceled(true);
                    ((LivingEntityAccessor)attacked).setLastHurt(6.9f * (float)currentAmp);
                    Objects.requireNonNull(attacked);
                    attacked.f_19802_ = 20;
                    CommonEvents.ENTITY_DAMAGE_BLOCK.invoke((Object)new EntityDamageBlockEvent.Data(false, damageSource, attacked));
                    int unsafeDuration = (int)(200.0f * (1.0f - blockChance));
                    int safeDuration = currentSpace.m_19557_();
                    attacked.m_21195_(ModEffects.SAFER_SPACE);
                    if (currentAmp > 0) {
                        attacked.m_7292_(new MobEffectInstance(ModEffects.SAFER_SPACE, safeDuration + unsafeDuration, currentAmp - 1, true, true, true));
                    }
                    attacked.m_7292_(new MobEffectInstance(ModEffects.SAFER_SPACE, unsafeDuration, 255, true, false, false));
                    if (attacked instanceof Player) {
                        Player player = (Player)attacked;
                        player.m_6330_(ModSounds.SAFERSPACES_PROC, SoundSource.PLAYERS, 0.4f, 1.0f);
                    }
                    attacked.m_5496_(ModSounds.SAFERSPACES_PROC, 0.4f, 1.0f);
                }
            } else if (!damageSource.m_146707_() && AttributeSnapshotHelper.canHaveSnapshot((LivingEntity)attacked)) {
                if (!Entropy.canExecute((Entity)attacked, (Entropy.Stat)Entropy.Stat.BLOCK, (float)blockChance)) {
                    CommonEvents.ENTITY_DAMAGE_BLOCK.invoke((Object)new EntityDamageBlockEvent.Data(true, damageSource, attacked));
                } else {
                    ItemStack shieldStack;
                    event.setCanceled(true);
                    CommonEvents.ENTITY_DAMAGE_BLOCK.invoke((Object)new EntityDamageBlockEvent.Data(false, damageSource, attacked));
                    ItemStack mainHandStack = attacked.m_21120_(InteractionHand.MAIN_HAND);
                    ItemStack offHandStack = attacked.m_21120_(InteractionHand.OFF_HAND);
                    Object object = mainHandStack.m_41720_() instanceof ShieldItem ? mainHandStack : (shieldStack = offHandStack.m_41720_() instanceof ShieldItem ? offHandStack : null);
                    if (shieldStack != null && shieldStack.m_41720_() instanceof VaultGearItem) {
                        VaultGearData gearData = VaultGearData.read((ItemStack)shieldStack);
                        gearData.getFirstValue(iskallia.vault.init.ModGearAttributes.GEAR_MODEL).flatMap(arg_0 -> ((DynamicModelRegistry)ModDynamicModels.Shields.REGISTRY).get(arg_0)).ifPresent(shieldModel -> shieldModel.onBlocked(attacked, damageSource));
                    }
                    attacked.m_183503_().m_7605_((Entity)attacked, (byte)29);
                    if (attacked instanceof Player) {
                        Player player = (Player)attacked;
                        BlockChanceHelper.setPlayerBlocking((Player)player);
                    }
                }
            }
        }
    }

    @Inject(method={"triggerAoEAttack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/DamageSource;getEntity()Lnet/minecraft/world/entity/Entity;", shift=At.Shift.AFTER)}, cancellable=true, remap=true)
    private static void triggerAoEAttack(LivingHurtEvent event, CallbackInfo ci) {
        if (ActiveFlags.IS_SMITE_ATTACKING.isSet() && !ActiveFlags.IS_SMITE_BASE_ATTACKING.isSet() || ActiveFlags.IS_AP_ATTACKING.isSet() || ActiveFlags.IS_THORNS_REFLECTING.isSet() || ActiveFlags.IS_REFLECT_ATTACKING.isSet()) {
            ci.cancel();
        }
    }

    @Inject(method={"lambda$triggerChainAttack$13"}, at={@At(value="HEAD")}, cancellable=true)
    private static void lambda$triggerChainAttack$10(Level world, LivingEntity attacked, float chainRange, LivingEntity attacker, LivingHurtEvent event, int chainCount, float finalChainStep, CallbackInfo ci) {
        List<Mob> nearby = EntityHelper.getNearby((LevelAccessor)world, (Vec3i)attacked.m_142538_(), (float)chainRange, Mob.class);
        ArrayList<Vec3> nearbyPos = new ArrayList<Vec3>();
        nearby.remove(attacked);
        nearby.remove(attacker);
        nearby.removeIf(mobx -> (attacker instanceof EternalEntity || attacker instanceof Player) && mobx instanceof EternalEntity);
        nearby.removeIf(mobx -> mobx.m_6673_(event.getSource()));
        if (!nearby.isEmpty()) {
            float baseMult;
            nearby.sort(Comparator.comparing(e -> Float.valueOf(e.m_20270_((Entity)attacked))));
            nearby = nearby.subList(0, Math.min(chainCount, nearby.size()));
            float multiplier = baseMult = 0.5f * (1.0f + ((Float)AttributeSnapshotHelper.getInstance().getSnapshot(attacker).getAttributeValue(ModGearAttributes.CHAINING_DAMAGE, VaultGearAttributeTypeMerger.floatSum())).floatValue());
            nearbyPos.add(attacked.m_20182_().m_82520_(0.0, (double)(attacked.m_20206_() / 3.0f), 0.0));
            for (Mob mob : nearby) {
                Vec3 movement = mob.m_20184_();
                nearbyPos.add(mob.m_20182_().m_82520_(0.0, (double)(mob.m_20206_() / 3.0f), 0.0));
                mob.m_6469_(event.getSource(), event.getAmount() * multiplier);
                mob.m_20256_(movement);
                multiplier *= baseMult;
            }
            CommonEvents.ENTITY_CHAIN_ATTACKED.invoke((Object)new EntityChainAttackedEvent.Data(attacker, nearby));
        }
        ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ChainingParticleMessage(nearbyPos));
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            PlayerActiveFlags.set((Player)player, (PlayerActiveFlags.Flag)PlayerActiveFlags.Flag.CHAINING_AOE, (int)2);
        }
        ci.cancel();
    }
}

