/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.custom;

import com.llamalad7.mixinextras.sugar.Local;
import iskallia.vault.config.gear.VaultEtchingConfig;
import iskallia.vault.gear.GearRollHelper;
import iskallia.vault.gear.VaultGearLegendaryHelper;
import iskallia.vault.gear.VaultGearModifierHelper;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearType;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.modification.GearModification;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.gear.CharmItem;
import iskallia.vault.item.gear.EtchingItem;
import iskallia.vault.item.gear.VaultCharmItem;
import iskallia.vault.item.gear.VaultNecklaceItem;
import iskallia.vault.item.tool.JewelItem;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.world.data.PlayerExpertisesData;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.iwolfking.woldsvaults.api.util.WoldGearModifierHelper;
import xyz.iwolfking.woldsvaults.expertises.CraftsmanExpertise;
import xyz.iwolfking.woldsvaults.expertises.EclecticGearExpertise;
import xyz.iwolfking.woldsvaults.init.ModGearAttributes;

@Mixin(value={GearRollHelper.class}, remap=false)
public class MixinGearRollHelper {
    @Shadow
    @Final
    public static Random rand;

    @Inject(method={"canGenerateLegendaryModifier"}, at={@At(value="TAIL")}, cancellable=true)
    private static void canGenerateLegendaryModifier(Player player, VaultGearData data, CallbackInfoReturnable<Boolean> cir) {
        if (data.equals(VaultGearData.empty())) {
            return;
        }
        if (data.getFirstValue(iskallia.vault.init.ModGearAttributes.CRAFTED_BY).isPresent() && rand.nextFloat() < ModConfigs.VAULT_GEAR_COMMON.getLegendaryModifierChance()) {
            ExpertiseTree expertises = PlayerExpertisesData.get((ServerLevel)((ServerLevel)player.m_183503_())).getExpertises(player);
            int craftsmanLevel = 0;
            for (CraftsmanExpertise craftsmanExpertise : expertises.getAll(CraftsmanExpertise.class, Skill::isUnlocked)) {
                craftsmanLevel = craftsmanExpertise.getCraftsmanLevel();
            }
            if (craftsmanLevel > 0) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"initializeGear(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="INVOKE", target="Liskallia/vault/gear/VaultGearModifierHelper;generateModifiers(Lnet/minecraft/world/item/ItemStack;Ljava/util/Random;)Liskallia/vault/gear/modification/GearModification$Result;", shift=At.Shift.AFTER)})
    private static void initializeGearWithEffects(ItemStack stack, Player player, CallbackInfo ci, @Local VaultGearData data) {
        int itemLevel;
        Item item;
        if (stack.m_41720_() instanceof CharmItem || stack.m_41720_() instanceof VaultNecklaceItem || stack.m_41720_() instanceof VaultCharmItem) {
            return;
        }
        if (stack.m_41720_() instanceof JewelItem && player == null) {
            return;
        }
        if (data.getFirstValue(ModGearAttributes.IS_ETCHED).orElse(false).booleanValue() && (item = stack.m_41720_()) instanceof VaultGearItem) {
            VaultGearItem vaultGearItem = (VaultGearItem)item;
        }
        if (!data.getFirstValue(iskallia.vault.init.ModGearAttributes.IS_LOOT).orElse(false).booleanValue()) {
            return;
        }
        float increasedSpecialRollsChance = 0.0f;
        if (player != null) {
            ExpertiseTree expertises = PlayerExpertisesData.get((ServerLevel)((ServerLevel)player.m_183503_())).getExpertises(player);
            for (EclecticGearExpertise eclecticGearExpertise : expertises.getAll(EclecticGearExpertise.class, Skill::isUnlocked)) {
                increasedSpecialRollsChance += eclecticGearExpertise.getIncreasedChance();
            }
        }
        if ((itemLevel = data.getItemLevel()) >= 65 && rand.nextFloat() <= 0.02f + increasedSpecialRollsChance) {
            GearModification.Result result = rand.nextBoolean() ? VaultGearModifierHelper.generateCorruptedImplicit((ItemStack)stack, (Random)rand) : VaultGearLegendaryHelper.improveExistingModifier((ItemStack)stack, (int)1, (Random)rand, List.of(VaultGearModifier.AffixCategory.CORRUPTED));
            if (result.success()) {
                VaultGearModifierHelper.setGearCorrupted((ItemStack)stack);
            }
        } else if (itemLevel >= 25 && rand.nextFloat() <= 0.02f + increasedSpecialRollsChance) {
            if (stack.m_41720_() instanceof JewelItem) {
                return;
            }
            VaultGearModifierHelper.lockRandomAffix((ItemStack)stack, (Random)rand);
        } else if (itemLevel >= 20 && rand.nextFloat() <= 0.02f + increasedSpecialRollsChance) {
            WoldGearModifierHelper.removeRandomModifierAlways(stack, rand);
            WoldGearModifierHelper.addUnusualModifier(stack, player.f_19853_.m_46467_(), rand);
        } else if (itemLevel >= 40 && rand.nextFloat() <= 0.01f + increasedSpecialRollsChance) {
            VaultGearLegendaryHelper.improveExistingModifier((ItemStack)stack, (int)1, (Random)rand, List.of(VaultGearModifier.AffixCategory.GREATER));
        } else if (rand.nextFloat() <= 0.04f + increasedSpecialRollsChance) {
            if (stack.m_41720_() instanceof JewelItem) {
                return;
            }
            VaultGearModifierHelper.improveGearRarity((ItemStack)stack, (Random)rand);
        }
    }

    @Inject(method={"initializeGear(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="TAIL")})
    private static void handleCorruptedJewelSize(ItemStack stack, Player player, CallbackInfo ci, @Local VaultGearData data) {
        if (stack.m_41720_() instanceof JewelItem) {
            if (data.getItemLevel() < 65 || rand.nextFloat() > 0.02f) {
                return;
            }
            GearModification.Result result = VaultGearLegendaryHelper.improveExistingModifier((ItemStack)stack, (int)1, (Random)rand, List.of(VaultGearModifier.AffixCategory.CORRUPTED));
            VaultGearData jData = VaultGearData.read((ItemStack)stack);
            if (result.success()) {
                List<VaultGearModifier> sizeMods = jData.getModifiers(VaultGearModifier.AffixType.IMPLICIT).stream().filter(vaultGearModifier -> vaultGearModifier.getAttribute() == iskallia.vault.init.ModGearAttributes.JEWEL_SIZE).toList();
                if (!sizeMods.isEmpty()) {
                    jData.removeModifier(sizeMods.get(0));
                }
                jData.addModifier(VaultGearModifier.AffixType.IMPLICIT, new VaultGearModifier(iskallia.vault.init.ModGearAttributes.JEWEL_SIZE, (Object)rand.nextInt(1, 26)));
                jData.write(stack);
                VaultGearModifierHelper.setGearCorrupted((ItemStack)stack);
            }
        }
    }

    @Unique
    private static boolean woldsVaults$canGenerateEtching(@Nullable Player player, VaultGearData data, ItemStack stack) {
        if (stack.getEquipmentSlot() != null && (stack.getEquipmentSlot().equals((Object)EquipmentSlot.CHEST) || stack.getEquipmentSlot().equals((Object)EquipmentSlot.FEET) || stack.getEquipmentSlot().equals((Object)EquipmentSlot.HEAD) || stack.getEquipmentSlot().equals((Object)EquipmentSlot.LEGS))) {
            return (Boolean)data.get(ModGearAttributes.IS_ETCHED, VaultGearAttributeTypeMerger.anyTrue());
        }
        return false;
    }

    @Unique
    private static void woldsvaults$addRandomEtchingEntry(VaultGearData data, VaultGearItem gear, ItemStack gearStack) {
        ItemStack etchingStack;
        if (data.hasAttribute(iskallia.vault.init.ModGearAttributes.ETCHING) || !data.isModifiable() || data.getRarity().equals((Object)VaultGearRarity.UNIQUE)) {
            return;
        }
        ResourceLocation etchingId = MixinGearRollHelper.woldsvaults$getRandomEtchingId();
        VaultEtchingConfig.EtchingEntry etchingEntry = ModConfigs.ETCHINGS.getEtchingConfig(etchingId);
        if (etchingEntry == null) {
            return;
        }
        List groups = etchingEntry.getTypeGroups();
        if (!groups.isEmpty()) {
            VaultGearType type = gear.getGearType(gearStack);
            boolean allowed = groups.stream().anyMatch(g -> ModConfigs.ETCHINGS.getGroup(g).contains(type));
            if (!allowed) {
                MixinGearRollHelper.woldsvaults$addRandomEtchingEntry(data, gear, gearStack);
            }
        }
        if ((etchingStack = EtchingItem.create((ResourceLocation)etchingId, (VaultEtchingConfig.EtchingEntry)etchingEntry, (Random)new Random(), (int)data.getItemLevel()).orElse(ItemStack.f_41583_)).m_41619_()) {
            return;
        }
        VaultGearData etchingData = VaultGearData.read((ItemStack)etchingStack);
        data.createOrReplaceAttributeValue(iskallia.vault.init.ModGearAttributes.ETCHING, (Object)etchingId);
        etchingData.getModifiers(VaultGearModifier.AffixType.IMPLICIT).forEach(modifier -> data.addModifier(VaultGearModifier.AffixType.IMPLICIT, modifier));
        data.write(gearStack);
    }

    @Unique
    private static ResourceLocation woldsvaults$getRandomEtchingId() {
        List etchings = ModConfigs.ETCHINGS.getEtchingIds().stream().toList();
        Random random = new Random();
        int randomIndex = random.nextInt(etchings.size());
        return (ResourceLocation)etchings.get(randomIndex);
    }
}

