/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.custom;

import com.llamalad7.mixinextras.sugar.Local;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.util.CoinDefinition;
import iskallia.vault.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.iwolfking.woldsvaults.mixins.vaulthunters.accessors.InventoryUtilItemAccessAccessor;

@Mixin(value={InventoryUtil.class}, remap=false)
public abstract class MixinInventoryUtil {
    @Inject(method={"getMissingInputs(Ljava/util/List;Lnet/minecraft/world/entity/player/Inventory;Liskallia/vault/container/oversized/OverSizedInventory;)Ljava/util/List;"}, at={@At(value="TAIL")}, cancellable=true)
    private static void checkCurrencyProperly(List<ItemStack> recipeInputs, Inventory playerInventory, OverSizedInventory containerInventory, CallbackInfoReturnable<List<ItemStack>> cir, @Local(ordinal=1) List<ItemStack> missing) {
        if (missing.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> trueMissing = new ArrayList<ItemStack>();
        for (ItemStack stack : missing) {
            if (CoinDefinition.getCoinDefinition((Item)stack.m_41720_()).isEmpty()) {
                trueMissing.add(stack);
                continue;
            }
            List<InventoryUtil.ItemAccess> itemAccesses = MixinInventoryUtil.findAllItems(playerInventory.f_35978_);
            if (itemAccesses == null) {
                return;
            }
            if (!CoinDefinition.hasEnoughCurrency(itemAccesses, (ItemStack)stack)) continue;
            cir.setReturnValue(trueMissing);
            return;
        }
    }

    @Shadow
    public static List<InventoryUtil.ItemAccess> findAllItems(Player player) {
        return null;
    }

    @Shadow
    public static boolean isEqualCrafting(ItemStack thisStack, ItemStack thatStack) {
        return false;
    }

    @Overwrite
    public static boolean consumeInputs(List<ItemStack> recipeInputs, Inventory playerInventory, OverSizedInventory tileInv, boolean simulate, List<OverSizedItemStack> consumed) {
        if (playerInventory.f_35978_.m_7500_()) {
            return true;
        }
        boolean success = true;
        for (ItemStack input : recipeInputs) {
            int deductedAmount;
            int neededCount = input.m_41613_();
            NonNullList overSizedContents = tileInv.getOverSizedContents();
            for (int slot = 0; slot < overSizedContents.size(); ++slot) {
                OverSizedItemStack overSized = (OverSizedItemStack)overSizedContents.get(slot);
                if (neededCount <= 0) break;
                if (!MixinInventoryUtil.isEqualCrafting(input, overSized.stack())) continue;
                deductedAmount = Math.min(neededCount, overSized.amount());
                if (!simulate) {
                    tileInv.setOverSizedStack(slot, overSized.addCopy(-deductedAmount));
                    consumed.add(overSized.copyAmount(deductedAmount));
                }
                neededCount -= overSized.amount();
            }
            for (InventoryUtil.ItemAccess plStack : MixinInventoryUtil.findAllItems(playerInventory.f_35978_)) {
                if (neededCount <= 0) break;
                if (!MixinInventoryUtil.isEqualCrafting(input, ((InventoryUtilItemAccessAccessor)plStack).getActualStack())) continue;
                deductedAmount = Math.min(neededCount, ((InventoryUtilItemAccessAccessor)plStack).getActualStack().m_41613_());
                if (!simulate) {
                    ((InventoryUtilItemAccessAccessor)plStack).getActualStack().m_41774_(deductedAmount);
                    ((InventoryUtilItemAccessAccessor)plStack).getSetter().accept(((InventoryUtilItemAccessAccessor)plStack).getActualStack());
                    ItemStack deducted = ((InventoryUtilItemAccessAccessor)plStack).getActualStack().m_41777_();
                    deducted.m_41764_(deductedAmount);
                    consumed.add(OverSizedItemStack.of((ItemStack)deducted));
                }
                neededCount -= deductedAmount;
            }
            if (neededCount > 0 && CoinDefinition.getCoinDefinition((Item)input.m_41720_()).isPresent()) {
                ItemStack inputNeeded = input.m_41777_();
                inputNeeded.m_41764_(neededCount);
                List<InventoryUtil.ItemAccess> itemAccesses = MixinInventoryUtil.findAllItems(playerInventory.f_35978_);
                if (CoinDefinition.hasEnoughCurrency(itemAccesses, (ItemStack)inputNeeded)) {
                    if (!simulate) {
                        CoinDefinition.extractCurrency((Player)playerInventory.f_35978_, itemAccesses, (ItemStack)inputNeeded);
                    }
                    neededCount -= neededCount;
                }
            }
            if (neededCount <= 0) continue;
            success = false;
        }
        return success;
    }
}

