/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.custom;

import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.DemagnetizerTileEntity;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.CuriosGearItem;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.trinket.TrinketHelper;
import iskallia.vault.gear.trinket.effects.EnderAnchorTrinket;
import iskallia.vault.init.ModParticles;
import iskallia.vault.item.MagnetItem;
import iskallia.vault.world.data.PlayerResearchesData;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import xyz.iwolfking.woldsvaults.api.util.MagnetPickupUtils;
import xyz.iwolfking.woldsvaults.init.ModGearAttributes;

@Mixin(value={MagnetItem.class}, remap=false)
public abstract class MixinMagnetItem
extends Item
implements VaultGearItem,
CuriosGearItem,
ICurioItem {
    @Unique
    private static final TagKey<Item> woldsvaults$DECOR_ITEMS = ItemTags.create((ResourceLocation)VaultMod.id((String)"decor"));

    public MixinMagnetItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @Shadow
    public static Optional<ItemStack> getMagnet(LivingEntity entity) {
        return Optional.empty();
    }

    @Shadow
    public static void teleportToPlayer(Player player, List<? extends Entity> entities) {
    }

    @Shadow
    public static void moveToPlayer(Player player, List<? extends Entity> entities, float speed) {
    }

    @Overwrite
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.START && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player = player2.f_19853_;
            if (player instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)player;
                MixinMagnetItem.getMagnet((LivingEntity)event.player).ifPresent(stack -> {
                    VaultGearItem gearItem;
                    Item patt2962$temp = stack.m_41720_();
                    if (patt2962$temp instanceof VaultGearItem && (gearItem = (VaultGearItem)patt2962$temp).isBroken(stack)) {
                        return;
                    }
                    if (!DemagnetizerTileEntity.hasDemagnetizerAround((Entity)event.player)) {
                        VaultGearData data = VaultGearData.read((ItemStack)stack);
                        float range = ((Float)data.get(iskallia.vault.init.ModGearAttributes.RANGE, VaultGearAttributeTypeMerger.floatSum())).floatValue();
                        float speed = ((Float)data.get(iskallia.vault.init.ModGearAttributes.VELOCITY, VaultGearAttributeTypeMerger.floatSum())).floatValue();
                        List items = world.m_6443_(ItemEntity.class, player2.m_142469_().m_82400_((double)range), entity -> entity.m_20280_((Entity)player2) <= (double)(range * range) && !entity.m_19880_().contains("PreventMagnetMovement"));
                        List orbs = world.m_6443_(ExperienceOrb.class, player2.m_142469_().m_82400_((double)range), entity -> entity.m_20280_((Entity)player2) <= (double)(range * range) && !entity.m_19880_().contains("PreventMagnetMovement"));
                        List enderAnchors = TrinketHelper.getTrinkets((LivingEntity)player2, EnderAnchorTrinket.class);
                        for (TrinketHelper.TrinketStack enderAnchor : enderAnchors) {
                            if (!enderAnchor.isUsable((Player)player2)) continue;
                            MixinMagnetItem.woldsVaults$teleportToPlayerEnhanced((Player)player2, items);
                            MixinMagnetItem.woldsVaults$teleportToPlayerEnhanced((Player)player2, orbs);
                            return;
                        }
                        if (((Boolean)AttributeGearData.read((ItemStack)stack).get(ModGearAttributes.MAGNET_ENDERGIZED, VaultGearAttributeTypeMerger.anyTrue())).booleanValue()) {
                            MixinMagnetItem.teleportToPlayer((Player)player2, items);
                            MixinMagnetItem.teleportToPlayer((Player)player2, orbs);
                        }
                        MixinMagnetItem.moveToPlayer((Player)player2, items, speed);
                        MixinMagnetItem.moveToPlayer((Player)player2, orbs, speed);
                    }
                });
            }
        }
    }

    @Unique
    private static void woldsVaults$teleportToPlayerEnhanced(Player player, List<? extends Entity> entities) {
        for (Entity entity : entities) {
            Level var5;
            ItemEntity item;
            if (entity instanceof ItemEntity && MixinMagnetItem.allowsNoPickupDelay(item = (ItemEntity)entity, player)) {
                item.m_32061_();
            }
            if ((var5 = player.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)var5;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.ENDER_ANCHOR.get()), entity.m_20182_().f_82479_, entity.m_20182_().f_82480_ + 0.25, entity.m_20182_().f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
            entity.m_6021_(player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_);
            entity.f_19864_ = true;
        }
    }

    @Shadow
    private static boolean allowsNoPickupDelay(ItemEntity itemEntity, Player player) {
        return false;
    }

    @Inject(method={"onPlayerPickup"}, at={@At(value="INVOKE", target="Liskallia/vault/item/MagnetItem;getMagnet(Lnet/minecraft/world/entity/LivingEntity;)Ljava/util/Optional;")}, cancellable=true)
    private static void removeDecorDmgIfJunkManagement(Player player, ItemEntity item, CallbackInfo ci) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if ((item.m_32055_().m_41720_().m_204114_().m_203656_(woldsvaults$DECOR_ITEMS) || MagnetPickupUtils.getPreviousStack(item).m_41720_().m_204114_().m_203656_(woldsvaults$DECOR_ITEMS)) && PlayerResearchesData.get((ServerLevel)serverPlayer.m_183503_()).getResearches((Player)serverPlayer).isResearched("Junk Management")) {
                ci.cancel();
            }
        }
    }
}

