/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.custom;

import iskallia.vault.core.vault.pylon.ManaPylonBuff;
import iskallia.vault.core.vault.pylon.PylonBuff;
import iskallia.vault.init.ModAttributes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ManaPylonBuff.class})
public class MixinManaPylonBuff
extends PylonBuff<ManaPylonBuff.Config> {
    @Unique
    protected int woldsVaults$tick = 0;

    public MixinManaPylonBuff(ManaPylonBuff.Config config) {
        super((PylonBuff.Config)config);
    }

    public boolean isDone() {
        return super.isDone() || this.woldsVaults$tick >= 1200;
    }

    public void onTick(MinecraftServer server) {
        super.onTick(server);
        this.getPlayer(server).ifPresent(player -> {
            AttributeModifier modifier = new AttributeModifier(this.uuid, "Pylon Buff", 1.0, AttributeModifier.Operation.ADDITION);
            AttributeInstance attribute = player.m_21051_(ModAttributes.MANA_REGEN);
            if (attribute != null && !attribute.m_22109_(modifier)) {
                attribute.m_22118_(modifier);
            }
        });
        ++this.woldsVaults$tick;
    }

    public void onRemove(MinecraftServer server) {
        this.getPlayer(server).ifPresent(player -> {
            AttributeInstance attribute = player.m_21051_(ModAttributes.MANA_REGEN);
            if (attribute != null) {
                attribute.m_22120_(this.uuid);
            }
        });
    }

    public void write(CompoundTag object) {
        super.write(object);
        object.m_128405_("tick", this.woldsVaults$tick);
    }

    public void read(CompoundTag object) {
        super.read(object);
        this.woldsVaults$tick = object.m_128451_("tick");
    }
}

