/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.custom;

import com.llamalad7.mixinextras.sugar.Local;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import iskallia.vault.config.VaultLevelsConfig;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.expertise.type.ExperiencedExpertise;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.world.data.PlayerExpertisesData;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.iwolfking.woldsvaults.WoldsVaults;
import xyz.iwolfking.woldsvaults.data.discovery.DiscoveredRecipesData;
import xyz.iwolfking.woldsvaults.integration.ftbquests.tasks.VaultLevelTask;

@Mixin(value={PlayerVaultStats.class}, remap=false)
public abstract class MixinPlayerVaultStats {
    @Shadow
    private int exp;
    @Shadow
    private int vaultLevel;
    @Shadow
    @Final
    private UUID uuid;
    @Unique
    private List<VaultLevelTask> woldsVaults$levelTasks = null;

    @Shadow
    public abstract int getVaultLevel();

    @Redirect(method={"addVaultExp"}, at=@At(value="INVOKE", target="Liskallia/vault/config/VaultLevelsConfig;getExpMultiplier()F"))
    private float addExperiencedExpertiseMultiplier(VaultLevelsConfig instance, @Local MinecraftServer server) {
        ServerPlayer player = server.m_6846_().m_11259_(this.uuid);
        if (player == null) {
            return instance.getExpMultiplier();
        }
        ExpertiseTree expertises = PlayerExpertisesData.get((ServerLevel)player.m_183503_()).getExpertises((Player)player);
        float increase = 0.0f;
        for (ExperiencedExpertise expertise1 : expertises.getAll(ExperiencedExpertise.class, Skill::isUnlocked)) {
            increase += expertise1.getIncreasedExpPercentage();
        }
        return instance.getExpMultiplier() + increase;
    }

    @Inject(method={"addVaultExp"}, at={@At(value="INVOKE", target="Liskallia/vault/core/event/common/VaultLevelUpEvent;invoke(Lnet/minecraft/server/level/ServerPlayer;III)Liskallia/vault/core/event/common/VaultLevelUpEvent$Data;")})
    private void progressFTBQuestsTasks(MinecraftServer server, int exp, CallbackInfo ci, @Local ServerPlayer player) {
        if (player.m_20194_() != null && this.vaultLevel >= 75 && !DiscoveredRecipesData.get(player.m_20194_()).hasDiscovered((Player)player, WoldsVaults.id("standard_trinket_pouch"))) {
            DiscoveredRecipesData.get(player.m_20194_()).discoverRecipeAndBroadcast(WoldsVaults.id("standard_trinket_pouch"), (Player)player);
        }
        this.woldsVaults$vaultLevelTaskProgress((Player)player, this.vaultLevel);
    }

    @Unique
    public void woldsVaults$vaultLevelTaskProgress(Player player, int newLevel) {
        if (this.woldsVaults$levelTasks == null) {
            this.woldsVaults$levelTasks = ServerQuestFile.INSTANCE.collect(VaultLevelTask.class);
        }
        if (this.woldsVaults$levelTasks.isEmpty()) {
            return;
        }
        TeamData data = ServerQuestFile.INSTANCE.getData((Entity)player);
        for (VaultLevelTask task : this.woldsVaults$levelTasks) {
            if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.quest)) continue;
            data.setProgress((Task)task, (long)newLevel);
        }
    }

    @Overwrite
    public int getExpNeededToNextLevel() {
        if (this.getVaultLevel() < 100) {
            return ModConfigs.LEVELS_META.getLevelMeta((int)this.vaultLevel).tnl;
        }
        return (int)((float)ModConfigs.LEVELS_META.getPrestigeTnl() + (float)ModConfigs.LEVELS_META.getPrestigeTnl() * ((float)(this.getVaultLevel() - 100) * 0.005f));
    }
}

