/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.custom;

import iskallia.vault.VaultMod;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.world.data.PlayerExpertisesData;
import iskallia.vault.world.data.ServerVaults;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.iwolfking.woldsvaults.api.util.VaultModifierUtils;
import xyz.iwolfking.woldsvaults.items.alchemy.AlchemyIngredientItem;
import xyz.iwolfking.woldsvaults.items.alchemy.CatalystItem;
import xyz.iwolfking.woldsvaults.modifiers.vault.RemoveBlacklistModifier;

@Mixin(value={Runner.class}, remap=false)
public abstract class MixinRunner
extends Listener {
    @Inject(method={"lambda$initServer$0"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;isCreative()Z", shift=At.Shift.AFTER, remap=true)}, cancellable=true)
    private void preventCancelingInteraction(VirtualWorld world, PlayerInteractEvent event, CallbackInfo ci) {
        if (ServerVaults.get((Level)world).isPresent()) {
            Vault vault = (Vault)ServerVaults.get((Level)world).get();
            List modifiers = ((Modifiers)vault.get(Vault.MODIFIERS)).getModifiers();
            for (VaultModifier modifier : modifiers) {
                RemoveBlacklistModifier removeBlacklistModifier;
                if (!(modifier instanceof RemoveBlacklistModifier) || !((RemoveBlacklistModifier.Properties)(removeBlacklistModifier = (RemoveBlacklistModifier)modifier).properties()).shouldUseAsBlacklist() || !((RemoveBlacklistModifier.Properties)removeBlacklistModifier.properties()).getWhitelist().isEmpty() || !((RemoveBlacklistModifier.Properties)removeBlacklistModifier.properties()).shouldApplyToItems()) continue;
                ci.cancel();
            }
        }
    }

    @Inject(method={"lambda$initServer$1"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;isCreative()Z", shift=At.Shift.AFTER)}, cancellable=true)
    private void preventCancelingInteraction(VirtualWorld world, BlockEvent.EntityPlaceEvent event, CallbackInfo ci) {
        if (ServerVaults.get((Level)world).isPresent()) {
            Vault vault = (Vault)ServerVaults.get((Level)world).get();
            List modifiers = ((Modifiers)vault.get(Vault.MODIFIERS)).getModifiers();
            for (VaultModifier modifier : modifiers) {
                RemoveBlacklistModifier removeBlacklistModifier;
                if (!(modifier instanceof RemoveBlacklistModifier) || !((RemoveBlacklistModifier.Properties)(removeBlacklistModifier = (RemoveBlacklistModifier)modifier).properties()).shouldUseAsBlacklist() || !((RemoveBlacklistModifier.Properties)removeBlacklistModifier.properties()).getWhitelist().isEmpty() || !((RemoveBlacklistModifier.Properties)removeBlacklistModifier.properties()).shouldApplyToBlocks()) continue;
                ci.cancel();
            }
        }
    }

    @Inject(method={"onJoin"}, at={@At(value="INVOKE", target="Liskallia/vault/core/vault/player/Listener;onJoin(Liskallia/vault/core/world/storage/VirtualWorld;Liskallia/vault/core/vault/Vault;)V")})
    private void addRandomPositiveModifiers(VirtualWorld world, Vault vault, CallbackInfo ci) {
        if (this.getPlayer().isPresent()) {
            ServerPlayer player = (ServerPlayer)this.getPlayer().get();
            ExpertiseTree expertiseTree = PlayerExpertisesData.get((MinecraftServer)player.f_8924_).getExpertises((Player)player);
            int surpriseModifiersExpertiseLevel = 0;
            for (Skill expertise : expertiseTree.skills) {
                if (!expertise.getId().equals("Surprise_Favors")) continue;
                surpriseModifiersExpertiseLevel = ((LearnableSkill)expertise).getSpentLearnPoints();
                break;
            }
            if (surpriseModifiersExpertiseLevel > 0 && world.m_5822_().nextFloat() < (float)surpriseModifiersExpertiseLevel * 0.2f) {
                VaultModifierUtils.addModifierFromPool(vault, VaultMod.id((String)"random_positive"));
            }
        }
    }

    @Inject(method={"onLeave"}, at={@At(value="TAIL")})
    private void addLeaveEvents(VirtualWorld world, Vault vault, CallbackInfo ci) {
        this.getPlayer().ifPresent(player -> {
            for (InventoryUtil.ItemAccess items : InventoryUtil.findAllItems((Player)player)) {
                ItemStack stack = items.getStack();
                if (!(stack.m_41720_() instanceof AlchemyIngredientItem) && !(stack.m_41720_() instanceof CatalystItem)) continue;
                items.setStack(ItemStack.f_41583_);
            }
        });
    }
}

