/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import iskallia.vault.client.gui.helper.FontHelper;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.core.vault.overlay.VaultOverlay;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.vault.time.TickTimer;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.iwolfking.woldsvaults.api.util.ComponentUtils;
import xyz.iwolfking.woldsvaults.api.util.CorruptedVaultHelper;

@Mixin(value={TickTimer.class}, remap=false)
public abstract class MixinTickTimer
extends TickClock {
    @Shadow
    protected abstract float getRotationTime(int var1);

    @Shadow
    protected abstract int getTextColor(int var1);

    @Inject(method={"getRotationTime"}, at={@At(value="HEAD")}, cancellable=true)
    protected void modifyRotation(int time, CallbackInfoReturnable<Float> cir) {
        if (CorruptedVaultHelper.isVaultCorrupted) {
            float value = super.getRotationTime(time);
            cir.setReturnValue((Object)Float.valueOf(value /= 6.0f));
        }
    }

    public void render(PoseStack matrixStack) {
        if (CorruptedVaultHelper.isVaultCorrupted) {
            TickTimer timer = (TickTimer)this;
            if (!timer.has(VISIBLE)) {
                return;
            }
            int hourglassWidth = 12;
            int hourglassHeight = 16;
            int color = this.getTextColor((Integer)timer.get(DISPLAY_TIME));
            MutableComponent cmp = ComponentUtils.corruptComponent((MutableComponent)new TextComponent(UIHelper.formatTimeString((long)((Integer)timer.get(DISPLAY_TIME)).intValue())));
            FontHelper.drawStringWithBorder((PoseStack)matrixStack, (Component)cmp, (float)-12.0f, (float)13.0f, (int)color, (int)-16777216);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)VaultOverlay.VAULT_HUD);
            float rotationTime = this.getRotationTime((Integer)this.get(DISPLAY_TIME));
            float degrees = (float)((Integer)timer.get(DISPLAY_TIME)).intValue() % rotationTime * 360.0f / rotationTime;
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(degrees));
            matrixStack.m_85837_((double)((float)(-hourglassWidth) / 2.0f), (double)((float)(-hourglassHeight) / 2.0f), 0.0);
            ScreenDrawHelper.drawTexturedQuads(buf -> ScreenDrawHelper.rect((VertexConsumer)buf, (PoseStack)matrixStack).dim((float)hourglassWidth, (float)hourglassHeight).texVanilla(1.0f, 36.0f, (float)hourglassWidth, (float)hourglassHeight).draw());
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        } else {
            super.render(matrixStack);
        }
    }
}

