/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.custom;

import com.llamalad7.mixinextras.sugar.Local;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.item.render.core.IManualModelLoading;
import iskallia.vault.item.tool.ToolItem;
import iskallia.vault.item.tool.ToolMaterial;
import iskallia.vault.item.tool.ToolType;
import java.util.function.Consumer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.iwolfking.woldsvaults.init.ModGearAttributes;
import xyz.iwolfking.woldsvaults.lib.ExtendedToolType;

@Mixin(value={ToolItem.class}, remap=false)
public abstract class MixinToolItem
extends TieredItem
implements VaultGearItem,
Vanishable,
IManualModelLoading {
    @Shadow
    @Final
    public static ResourceLocation SPAWNER_ID;

    @Shadow
    public static ToolMaterial getMaterial(@NotNull ItemStack stack) {
        return null;
    }

    public MixinToolItem(Tier pTier, Item.Properties pProperties) {
        super(pTier, pProperties);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"loadModels"}, at={@At(value="TAIL")})
    public void loadExtendedModels(Consumer<ModelResourceLocation> consumer, CallbackInfo ci) {
        ExtendedToolType[] extendedToolTypes;
        for (ExtendedToolType type : extendedToolTypes = ExtendedToolType.values()) {
            consumer.accept(new ModelResourceLocation("the_vault:tool/%s/handle#inventory.".formatted(type.getId())));
            for (ToolMaterial material : ToolMaterial.values()) {
                consumer.accept(new ModelResourceLocation("the_vault:tool/%s/head/%s#inventory".formatted(type.getId(), material.getId())));
            }
        }
    }

    @Inject(method={"getName"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    public void getName(ItemStack stack, CallbackInfoReturnable<Component> cir) {
        ToolType type = ToolType.of((ItemStack)stack);
        ToolMaterial material = MixinToolItem.getMaterial(stack);
        ExtendedToolType extendedToolType = ExtendedToolType.of(stack);
        if (type == null && extendedToolType != null && material != null) {
            cir.setReturnValue((Object)new TranslatableComponent(material.getDescription()).m_130946_(" ").m_7220_((Component)new TranslatableComponent(extendedToolType.getDescription())));
        }
    }

    @Inject(method={"hasAffinity"}, at={@At(value="TAIL")}, cancellable=true)
    public void hasAffinity(ItemStack stack, BlockState state, CallbackInfoReturnable<Boolean> cir, @Local VaultGearData data) {
        if (((Boolean)data.get(ModGearAttributes.TREASURE_AFFINITY, VaultGearAttributeTypeMerger.anyTrue())).booleanValue() && state.m_60713_(ModBlocks.TREASURE_CHEST)) {
            cir.setReturnValue((Object)true);
        }
    }
}

