/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.custom;

import com.llamalad7.mixinextras.sugar.Local;
import iskallia.vault.block.entity.ToolStationTileEntity;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.gear.crafting.ToolStationHelper;
import iskallia.vault.util.CoinDefinition;
import iskallia.vault.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ToolStationHelper.class}, remap=false)
public abstract class MixinToolStationHelper {
    @Shadow
    private static boolean isEqualCrafting(ItemStack thisStack, ItemStack thatStack) {
        return false;
    }

    @Inject(method={"getMissingInputs"}, at={@At(value="TAIL")}, cancellable=true)
    private static void checkCurrencyProperly(List<ItemStack> recipeInputs, Inventory playerInventory, ToolStationTileEntity tile, CallbackInfoReturnable<List<ItemStack>> cir, @Local(ordinal=1) List<ItemStack> missing) {
        if (missing.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> trueMissing = new ArrayList<ItemStack>();
        for (ItemStack stack : missing) {
            if (CoinDefinition.getCoinDefinition((Item)stack.m_41720_()).isEmpty()) {
                trueMissing.add(stack);
                continue;
            }
            List itemAccesses = InventoryUtil.findAllItems((Player)playerInventory.f_35978_);
            if (!CoinDefinition.hasEnoughCurrency((List)itemAccesses, (ItemStack)stack)) continue;
            cir.setReturnValue(trueMissing);
            return;
        }
    }

    @Overwrite
    public static boolean consumeInputs(List<ItemStack> recipeInputs, Inventory playerInventory, ToolStationTileEntity tile, boolean simulate, List<OverSizedItemStack> consumed) {
        boolean missingInput = true;
        for (ItemStack input : recipeInputs) {
            int deductedAmount;
            int neededCount = input.m_41613_();
            NonNullList overSizedContents = tile.getInventory().getOverSizedContents();
            for (int slot = 0; slot < overSizedContents.size(); ++slot) {
                OverSizedItemStack overSized = (OverSizedItemStack)overSizedContents.get(slot);
                if (neededCount <= 0) break;
                if (!MixinToolStationHelper.isEqualCrafting(input, overSized.stack())) continue;
                deductedAmount = Math.min(neededCount, overSized.amount());
                if (!simulate) {
                    tile.getInventory().setOverSizedStack(slot, overSized.addCopy(-deductedAmount));
                    consumed.add(overSized.copyAmount(deductedAmount));
                }
                neededCount -= overSized.amount();
            }
            for (ItemStack plStack : playerInventory.f_35974_) {
                if (neededCount <= 0) break;
                if (!MixinToolStationHelper.isEqualCrafting(input, plStack)) continue;
                deductedAmount = Math.min(neededCount, plStack.m_41613_());
                if (!simulate) {
                    ItemStack deducted = plStack.m_41777_();
                    deducted.m_41764_(deductedAmount);
                    consumed.add(OverSizedItemStack.of((ItemStack)deducted));
                    plStack.m_41774_(deductedAmount);
                }
                neededCount -= deductedAmount;
            }
            if (neededCount > 0 && CoinDefinition.getCoinDefinition((Item)input.m_41720_()).isPresent()) {
                ItemStack inputNeeded = input.m_41777_();
                inputNeeded.m_41764_(neededCount);
                List itemAccesses = InventoryUtil.findAllItems((Player)playerInventory.f_35978_);
                if (CoinDefinition.hasEnoughCurrency((List)itemAccesses, (ItemStack)inputNeeded)) {
                    if (!simulate) {
                        CoinDefinition.extractCurrency((Player)playerInventory.f_35978_, (List)itemAccesses, (ItemStack)inputNeeded);
                    }
                    neededCount -= neededCount;
                }
            }
            if (neededCount <= 0) continue;
            missingInput = false;
        }
        return missingInput;
    }
}

