/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.custom;

import com.llamalad7.mixinextras.sugar.Local;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.gear.item.IdentifiableItem;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.item.BasicItem;
import iskallia.vault.item.core.DataTransferItem;
import iskallia.vault.item.gear.RecyclableItem;
import iskallia.vault.item.gear.TrinketItem;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mixin(value={TrinketItem.class}, remap=false)
public abstract class MixinTrinketItem
extends BasicItem
implements ICurioItem,
DataTransferItem,
RecyclableItem,
IdentifiableItem {
    public MixinTrinketItem(ResourceLocation id) {
        super(id);
    }

    @Inject(method={"canEquip"}, at={@At(value="HEAD")}, cancellable=true)
    public void canEquip(SlotContext slotContext, ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            IItemHandlerModifiable curioHandler;
            Player player = (Player)livingEntity;
            LazyOptional curioHandlerOpt = CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player);
            if (curioHandlerOpt.isPresent() && (curioHandler = (IItemHandlerModifiable)curioHandlerOpt.resolve().orElse(null)) != null) {
                for (int i = 0; i < curioHandler.getSlots(); ++i) {
                    TrinketEffect effect;
                    ItemStack curioStack = curioHandler.getStackInSlot(i);
                    if (!(curioStack.m_41720_() instanceof TrinketItem) || (effect = (TrinketEffect)TrinketItem.getTrinket((ItemStack)curioStack).orElse(null)) == null || !effect.equals(TrinketItem.getTrinket((ItemStack)stack).orElse(null))) continue;
                    cir.setReturnValue((Object)false);
                }
            }
        }
    }

    @Redirect(method={"canUnequip"}, at=@At(value="INVOKE", target="Ljava/util/Optional;isPresent()Z"))
    public boolean allowUnequip(Optional<Vault> vault, @Local(argsOnly=true) ItemStack stack) {
        return vault.isPresent() && !TrinketItem.isUsableInVault((ItemStack)stack, (UUID)((UUID)vault.get().get(Vault.ID)));
    }

    @Redirect(method={"canEquip"}, at=@At(value="INVOKE", target="Ljava/util/Optional;isPresent()Z"))
    public boolean allowReequip(Optional<Vault> vault, @Local(argsOnly=true) ItemStack stack) {
        return vault.isPresent() && !TrinketItem.isUsableInVault((ItemStack)stack, (UUID)((UUID)vault.get().get(Vault.ID)));
    }
}

