/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.custom;

import iskallia.vault.config.recipe.ForgeRecipeType;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.crafting.recipe.GearForgeRecipe;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.world.data.PlayerGreedData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import xyz.iwolfking.woldsvaults.data.discovery.ClientPlayerGreedData;
import xyz.iwolfking.woldsvaults.items.AirMobilityItem;
import xyz.iwolfking.woldsvaults.items.gear.VaultMapItem;

@Mixin(value={GearForgeRecipe.class}, remap=false)
public abstract class MixinVaultGearRecipe
extends VaultForgeRecipe {
    @Unique
    private static final ResourceLocation ETCHING_LOCATION = new ResourceLocation("the_vault", "etching");
    @Unique
    private static final ResourceLocation MAP_LOCATION = new ResourceLocation("the_vault", "map");
    private static final ResourceLocation ZEPHYR_LOCATION = new ResourceLocation("woldsvaults", "zephyr_charm");

    protected MixinVaultGearRecipe(ForgeRecipeType type, ResourceLocation id, ItemStack output) {
        super(type, id, output);
    }

    public boolean canCraft(Player player) {
        if (!(this.getId().equals((Object)ETCHING_LOCATION) || this.getId().equals((Object)MAP_LOCATION) || this.getId().equals((Object)ZEPHYR_LOCATION))) {
            return true;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            PlayerGreedData greedData = PlayerGreedData.get((MinecraftServer)sPlayer.f_8924_);
            return greedData.get(player).hasCompletedHerald();
        }
        return !ClientPlayerGreedData.getArtifactData().isEmpty();
    }

    @Overwrite
    public ItemStack getDisplayOutput(int vaultLevel) {
        ItemStack out = super.getDisplayOutput(vaultLevel);
        if (!(out.m_41720_() instanceof VaultGearItem)) {
            return out;
        }
        VaultGearData data = VaultGearData.read((ItemStack)out);
        data.setState(VaultGearState.IDENTIFIED);
        data.setItemLevel(vaultLevel);
        data.write(out);
        return out;
    }

    public List<Component> getDisabledText() {
        if (this.output.m_41720_() instanceof AirMobilityItem || this.output.m_41720_() instanceof VaultMapItem) {
            return List.of(new TextComponent("Defeat The Herald by collecting all 25 Artifacts to unlock."));
        }
        return List.of(new TextComponent("Undiscovered").m_130940_(ChatFormatting.ITALIC));
    }
}

