/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.custom;

import iskallia.vault.core.vault.modifier.VaultModifierStack;
import iskallia.vault.core.vault.modifier.modifier.EmptyModifier;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import xyz.iwolfking.woldsvaults.modifiers.vault.lib.SettableValueVaultModifier;

@Mixin(value={VaultModifierStack.class}, remap=false)
public class MixinVaultModifierStack {
    @Shadow
    private VaultModifier<?> modifier;
    @Shadow
    private int size;

    @Overwrite
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("id", this.modifier.getId().toString());
        nbt.m_128405_("size", this.size);
        VaultModifier<?> vaultModifier = this.modifier;
        if (vaultModifier instanceof SettableValueVaultModifier) {
            SettableValueVaultModifier settableValueVaultModifier = (SettableValueVaultModifier)vaultModifier;
            nbt.m_128350_("value", ((SettableValueVaultModifier.Properties)settableValueVaultModifier.properties()).getValue());
        }
        return nbt;
    }

    @Overwrite
    public void deserializeNBT(CompoundTag nbt) {
        ResourceLocation id = new ResourceLocation(nbt.m_128461_("id"));
        this.modifier = VaultModifierRegistry.getOrDefault((ResourceLocation)id, (VaultModifier)EmptyModifier.INSTANCE);
        VaultModifier<?> vaultModifier = this.modifier;
        if (vaultModifier instanceof SettableValueVaultModifier) {
            SettableValueVaultModifier settableValueVaultModifier = (SettableValueVaultModifier)vaultModifier;
            ((SettableValueVaultModifier.Properties)settableValueVaultModifier.properties()).setValue(Float.valueOf(nbt.m_128457_("value")));
        }
        this.size = nbt.m_128451_("size");
    }

    @Overwrite
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.modifier.getId());
        buffer.writeInt(this.size);
        VaultModifier<?> vaultModifier = this.modifier;
        if (vaultModifier instanceof SettableValueVaultModifier) {
            SettableValueVaultModifier settableValueVaultModifier = (SettableValueVaultModifier)vaultModifier;
            buffer.writeFloat(((SettableValueVaultModifier.Properties)settableValueVaultModifier.properties()).getValue());
        }
    }

    @Overwrite
    public static VaultModifierStack decode(FriendlyByteBuf buffer) {
        ResourceLocation resourceLocation = buffer.m_130281_();
        VaultModifier modifier = VaultModifierRegistry.getOrDefault((ResourceLocation)resourceLocation, (VaultModifier)EmptyModifier.INSTANCE);
        int size = buffer.readInt();
        if (modifier instanceof SettableValueVaultModifier) {
            SettableValueVaultModifier settableValueVaultModifier = (SettableValueVaultModifier)modifier;
            ((SettableValueVaultModifier.Properties)settableValueVaultModifier.properties()).setValue(Float.valueOf(buffer.readFloat()));
        }
        return new VaultModifierStack(modifier, size);
    }
}

