/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.custom;

import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.BaseSpawnerTileEntity;
import iskallia.vault.block.entity.WildSpawnerTileEntity;
import iskallia.vault.config.WildSpawnerConfig;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.world.data.ServerVaults;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={WildSpawnerTileEntity.class}, remap=false)
public class MixinWildSpawnerTileEntity
extends BaseSpawnerTileEntity {
    @Shadow
    @Nullable
    private WildSpawnerConfig.SpawnerGroup spawnerGroup;
    @Shadow
    private int playerCheckCooldown;

    protected MixinWildSpawnerTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Overwrite
    private static void spawnEntity(Level level, BlockPos blockPos, ServerLevel serverLevel, WildSpawnerConfig.SpawnerGroup spawnerGroup) {
        WildSpawnerConfig.SpawnerEntity spawnerEntity = (WildSpawnerConfig.SpawnerEntity)spawnerGroup.entities.getRandom(level.f_46441_);
        if (spawnerEntity == null) {
            VaultMod.LOGGER.warn("Wild Spawner failed to spawn as there was no valid entity found in config for spawn group with minLevel {}", (Object)spawnerGroup.minLevel);
        } else if (spawnerEntity.type.toString().equals("quark:wraith")) {
            MixinWildSpawnerTileEntity.spawnBuffedWraith(blockPos, serverLevel, spawnerEntity.type, spawnerEntity.nbt, false, () -> VaultMod.LOGGER.warn("Wild Spawner failed to spawn \"{}\" as it does not exist in entityType registry", (Object)spawnerEntity.type));
        } else {
            MixinWildSpawnerTileEntity.spawnEntity((BlockPos)blockPos, (ServerLevel)serverLevel, (ResourceLocation)spawnerEntity.type, (CompoundTag)spawnerEntity.nbt, (boolean)false, () -> VaultMod.LOGGER.warn("Wild Spawner failed to spawn \"{}\" as it does not exist in entityType registry", (Object)spawnerEntity.type));
        }
    }

    @Unique
    @Nullable
    private static Entity spawnBuffedWraith(BlockPos blockPos, ServerLevel serverLevel, ResourceLocation entityName, @Nullable CompoundTag entityNbt, boolean isPersistent, Runnable logEntityTypeMissing) {
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(entityName);
        if (entityType == null) {
            logEntityTypeMissing.run();
            return null;
        }
        Entity entity = entityType.m_20592_(serverLevel, null, null, blockPos, MobSpawnType.SPAWNER, false, false);
        if (entityNbt != null) {
            CompoundTag entityTag = entity.m_20240_(new CompoundTag());
            entityTag.m_128391_(entityNbt.m_6426_());
            entity.m_20258_(entityTag);
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (isPersistent) {
                mob.m_21530_();
            }
            mob.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 32567, 10));
        }
        return entity;
    }

    @Overwrite
    private void initSpawnerGroup() {
        if (this.spawnerGroup == null) {
            int vaultLevel = ServerVaults.get((Level)this.f_58857_).map(vault -> ((VaultLevel)vault.get(Vault.LEVEL)).get()).orElse(0);
            Vault vaultObj = (Vault)ServerVaults.get((Level)this.f_58857_).get();
            String objective = (String)((Objectives)vaultObj.get(Vault.OBJECTIVES)).get(Objectives.KEY);
            boolean hasSpooky = false;
            for (WildSpawnerConfig.SpawnerGroup sg : ModConfigs.WILD_SPAWNER.spawnerGroups) {
                if (sg.minLevel > vaultLevel || this.spawnerGroup != null && sg.minLevel <= this.spawnerGroup.minLevel) continue;
                if (!objective.equals("haunted_braziers")) {
                    hasSpooky = ((Modifiers)vaultObj.get(Vault.MODIFIERS)).getModifiers().stream().anyMatch(vaultModifier -> vaultModifier.getId().toString().equals("the_vault:spooky"));
                }
                if (objective.equals("haunted_braziers") || hasSpooky) {
                    this.spawnerGroup = (WildSpawnerConfig.SpawnerGroup)ModConfigs.WILD_SPAWNER.spawnerGroups.get(3);
                    continue;
                }
                this.spawnerGroup = sg;
            }
        }
    }
}

