/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.custom;

import iskallia.vault.block.entity.ModifierWorkbenchTileEntity;
import iskallia.vault.config.gear.VaultGearWorkbenchConfig;
import iskallia.vault.gear.VaultGearModifierHelper;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.crafting.ModifierWorkbenchHelper;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.world.data.PlayerExpertisesData;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import xyz.iwolfking.woldsvaults.api.util.ModifierWorkbenchMixinHelper;
import xyz.iwolfking.woldsvaults.expertises.CraftsmanExpertise;
import xyz.iwolfking.woldsvaults.mixins.vaulthunters.accessors.MixinModifierWorkbenchCraftMessageAccessor;

@Mixin(value={iskallia.vault.network.message.ModifierWorkbenchCraftMessage.class}, remap=false)
public class ModifierWorkbenchCraftMessage {
    @Overwrite
    public static void handle(iskallia.vault.network.message.ModifierWorkbenchCraftMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ModifierWorkbenchTileEntity workbenchTile;
            ItemStack input;
            ServerPlayer player = context.getSender();
            ExpertiseTree expertises = PlayerExpertisesData.get((ServerLevel)player.m_183503_()).getExpertises((Player)player);
            int craftsmanLevel = 0;
            for (CraftsmanExpertise craftsmanExpertise : expertises.getAll(CraftsmanExpertise.class, Skill::isUnlocked)) {
                craftsmanLevel = craftsmanExpertise.getCraftsmanLevel();
            }
            int numberOfAllowedModifiers = craftsmanLevel == 0 ? 1 : craftsmanLevel;
            BlockPos pos = ((MixinModifierWorkbenchCraftMessageAccessor)message).getPos();
            BlockEntity tile = player.m_183503_().m_7702_(pos);
            if (tile instanceof ModifierWorkbenchTileEntity && !(input = (workbenchTile = (ModifierWorkbenchTileEntity)tile).getInventory().m_8020_(0)).m_41619_() && input.m_41720_() instanceof VaultGearItem && AttributeGearData.hasData((ItemStack)input) && VaultGearData.read((ItemStack)input).isModifiable()) {
                int craftsmanLevelCopy = craftsmanLevel;
                VaultGearWorkbenchConfig.getConfig((Item)input.m_41720_()).ifPresent(cfg -> {
                    ItemStack inputCopy = input.m_41777_();
                    VaultGearModifier.AffixType targetAffix = null;
                    VaultGearModifier createdModifier = null;
                    ArrayList cost = new ArrayList();
                    if (((MixinModifierWorkbenchCraftMessageAccessor)message).getCraftModifierIdentifier() == null) {
                        if (!ModifierWorkbenchHelper.hasCraftedModifier((ItemStack)inputCopy)) {
                            return;
                        }
                        cost.addAll(cfg.getCostRemoveCraftedModifiers());
                    } else {
                        VaultGearWorkbenchConfig.CraftableModifierConfig modifierConfig = cfg.getConfig(((MixinModifierWorkbenchCraftMessageAccessor)message).getCraftModifierIdentifier());
                        if (modifierConfig == null) {
                            return;
                        }
                        if (!modifierConfig.hasPrerequisites((Player)player)) {
                            return;
                        }
                        VaultGearData data = VaultGearData.read((ItemStack)inputCopy);
                        boolean hadCraftedModifiers = ModifierWorkbenchHelper.hasCraftedModifier((ItemStack)inputCopy);
                        boolean isCrafted = data.getFirstValue(ModGearAttributes.CRAFTED_BY).isPresent();
                        if (ModifierWorkbenchMixinHelper.getCraftedModifierCount(inputCopy) > numberOfAllowedModifiers && isCrafted) {
                            ModifierWorkbenchHelper.removeCraftedModifiers((ItemStack)inputCopy);
                        } else if (!isCrafted) {
                            ModifierWorkbenchHelper.removeCraftedModifiers((ItemStack)inputCopy);
                        }
                        if (data.getItemLevel() < modifierConfig.getMinLevel()) {
                            return;
                        }
                        targetAffix = modifierConfig.getAffixGroup().getTargetAffixType();
                        if (targetAffix == VaultGearModifier.AffixType.PREFIX ? !VaultGearModifierHelper.hasOpenPrefix((ItemStack)inputCopy) : !VaultGearModifierHelper.hasOpenSuffix((ItemStack)inputCopy)) {
                            return;
                        }
                        createdModifier = modifierConfig.createModifier().orElse(null);
                        if (createdModifier == null) {
                            return;
                        }
                        Set existingModGroups = data.getExistingModifierGroups(VaultGearData.Type.EXPLICIT_MODIFIERS);
                        if (existingModGroups.contains(createdModifier.getModifierGroup())) {
                            return;
                        }
                        cost.addAll(modifierConfig.createCraftingCost(inputCopy));
                        if (hadCraftedModifiers && ModifierWorkbenchMixinHelper.getCraftedModifierCount(input) > numberOfAllowedModifiers && isCrafted) {
                            cost.addAll(cfg.getCostRemoveCraftedModifiers());
                        } else if (hadCraftedModifiers && !isCrafted) {
                            cost.addAll(cfg.getCostRemoveCraftedModifiers());
                        }
                    }
                    List missing = InventoryUtil.getMissingInputs(cost, (Inventory)player.m_150109_());
                    if (missing.isEmpty() && InventoryUtil.consumeInputs(cost, (Inventory)player.m_150109_(), (boolean)true) && InventoryUtil.consumeInputs(cost, (Inventory)player.m_150109_(), (boolean)false)) {
                        boolean isCrafted = VaultGearData.read((ItemStack)input).getFirstValue(ModGearAttributes.CRAFTED_BY).isPresent();
                        if (createdModifier == null) {
                            ModifierWorkbenchHelper.removeCraftedModifiers((ItemStack)input);
                        } else {
                            createdModifier.addCategory(VaultGearModifier.AffixCategory.CRAFTED);
                            createdModifier.setGameTimeAdded(player.m_183503_().m_46467_());
                            if (ModifierWorkbenchMixinHelper.getCraftedModifierCount(input) > numberOfAllowedModifiers && isCrafted) {
                                ModifierWorkbenchHelper.removeCraftedModifiers((ItemStack)input);
                            } else if (!isCrafted) {
                                ModifierWorkbenchHelper.removeCraftedModifiers((ItemStack)input);
                            }
                            VaultGearData datax = VaultGearData.read((ItemStack)input);
                            datax.addModifier(targetAffix, createdModifier);
                            datax.write(input);
                        }
                        player.m_183503_().m_46796_(1030, tile.m_58899_(), 0);
                    }
                });
            }
        });
        context.setPacketHandled(true);
    }
}

