/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.fixes;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import iskallia.vault.block.GateLockBlock;
import iskallia.vault.block.entity.GateLockTileEntity;
import iskallia.vault.block.render.GateLockRenderer;
import iskallia.vault.client.ClientStatisticsData;
import iskallia.vault.config.VaultModifierOverlayConfig;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.core.vault.modifier.VaultModifierStack;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.overlay.ModifiersRenderer;
import iskallia.vault.init.ModConfigs;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={GateLockRenderer.class}, remap=false)
public abstract class MixinGateRenderer {
    @Shadow
    public abstract void renderLine(Component var1, boolean var2, PoseStack var3, MultiBufferSource var4, int var5);

    @Shadow
    protected abstract boolean check(List<ItemStack> var1, ItemStack var2, boolean var3);

    @Shadow
    public abstract void renderItemLine(ItemStack var1, Component var2, Component var3, boolean var4, PoseStack var5, MultiBufferSource var6, int var7);

    @Overwrite
    public void render(GateLockTileEntity entity, float pPartialTick, PoseStack matrices, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        if (entity.getGod() != null) {
            int reputation;
            BlockState blockstate = entity.m_58900_();
            matrices.m_85836_();
            float f = 0.6666667f;
            Vec3i vector = ((Direction)blockstate.m_61143_((Property)GateLockBlock.FACING)).m_122436_();
            matrices.m_85837_(0.5 + 0.9 * (double)vector.m_123341_(), 0.5 + 0.9 * (double)vector.m_123342_(), 0.5 + 0.9 * (double)vector.m_123343_());
            float f4 = -((Direction)blockstate.m_61143_((Property)GateLockBlock.FACING)).m_122435_();
            matrices.m_85845_(Vector3f.f_122225_.m_122240_(f4));
            matrices.m_85837_(0.0, -0.3125, -0.4375);
            matrices.m_85837_(0.0, 0.3333333432674408, 0.046666666865348816);
            matrices.m_85841_(0.010416667f, -0.010416667f, 0.010416667f);
            matrices.m_85836_();
            matrices.m_85836_();
            matrices.m_85841_(2.0f, 2.0f, 2.0f);
            this.renderLine((Component)new TextComponent(entity.getName()).m_130948_(Style.f_131099_.m_178520_(entity.getColor())), true, matrices, pBufferSource, pPackedLight);
            matrices.m_85849_();
            Minecraft minecraft = Minecraft.m_91087_();
            List<ItemStack> items = minecraft.f_91074_.f_36095_.m_38927_().stream().map(ItemStack::m_41777_).toList();
            int count = entity.getModifiers().size();
            if (count > 0) {
                matrices.m_85837_(0.0, 30.0, 0.0);
                matrices.m_85836_();
                int right = minecraft.m_91268_().m_85445_();
                reputation = minecraft.m_91268_().m_85446_();
                matrices.m_85837_((double)(-right), (double)(-reputation), 0.0);
                VaultModifierOverlayConfig config = ModConfigs.VAULT_MODIFIER_OVERLAY;
                matrices.m_85837_((double)config.spacingX + (double)((config.size + config.spacingX) * count) / 2.0, 0.0, 0.0);
                ModifiersRenderer.renderVaultModifiers((List)entity.getModifiers(), (PoseStack)matrices);
                matrices.m_85849_();
            }
            AtomicInteger index = new AtomicInteger(1);
            for (VaultModifierStack stack : entity.getModifiers()) {
                VaultModifierRegistry.getOpt((ResourceLocation)stack.getModifierId()).ifPresent(modifier -> {
                    matrices.m_85836_();
                    matrices.m_85837_(0.0, 10.0 * (double)index.get(), 0.0);
                    String modifierName = modifier.getChatDisplayNameComponent(stack.getSize()).getString();
                    modifierName = modifierName.replaceAll(":.*: *", "");
                    Style style = Style.f_131099_.m_131148_(modifier.getDisplayTextColor());
                    this.renderLine((Component)new TextComponent(modifierName).m_130948_(style), true, matrices, pBufferSource, pPackedLight);
                    matrices.m_85849_();
                    index.getAndIncrement();
                });
            }
            if (entity.getReputationCost() > 0) {
                matrices.m_85837_(0.0, 10.0 * (double)index.get(), 0.0);
                matrices.m_85836_();
                reputation = ClientStatisticsData.getReputation((VaultGod)entity.getGod());
                ChatFormatting form = reputation >= entity.getReputationCost() ? ChatFormatting.WHITE : ChatFormatting.RED;
                this.renderLine((Component)new TextComponent("").m_7220_((Component)new TextComponent(entity.getReputationCost() + " ").m_130940_(form)).m_7220_((Component)new TextComponent(entity.getGod().getName()).m_130940_(entity.getGod().getChatColor())).m_7220_((Component)new TextComponent(" Reputation").m_130940_(form)), true, matrices, pBufferSource, pPackedLight);
                matrices.m_85849_();
            }
            for (VaultModifierStack stack : entity.getCost()) {
                matrices.m_85837_(0.0, 45.0, 0.0);
                ChatFormatting color = this.check(items, stack.m_41777_(), true) && this.check(items, stack.m_41777_(), false) ? ChatFormatting.WHITE : ChatFormatting.RED;
                this.renderItemLine((ItemStack)stack, (Component)stack.m_41786_().m_6881_().m_130940_(color), (Component)new TextComponent((String)(stack.m_41613_() < 10 ? " " : "" + stack.m_41613_())).m_130940_(color), true, matrices, pBufferSource, pPackedLight);
            }
            matrices.m_85849_();
            matrices.m_85849_();
        }
    }
}

