/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.fixes;

import iskallia.vault.VaultMod;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.gear.GearScoreHelper;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.GearDataCache;
import iskallia.vault.gear.data.VaultGearData;
import java.util.ArrayList;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={GearScoreHelper.class}, remap=false)
public class MixinGearScoreHelper {
    @Overwrite
    public static int getWeight(ItemStack stack) {
        AttributeGearData attributeData = AttributeGearData.read((ItemStack)stack);
        if (attributeData instanceof VaultGearData) {
            VaultGearData gearData = (VaultGearData)attributeData;
            GearDataCache cache = GearDataCache.of((ItemStack)stack);
            int weight = 0;
            if (cache.hasModifierOfCategory(VaultGearModifier.AffixCategory.LEGENDARY)) {
                weight += 1000000;
            }
            VaultGearRarity rarity = gearData.getRarity();
            weight += rarity.ordinal() * 10000;
            VaultGearTierConfig cfg = VaultGearTierConfig.getConfig((ItemStack)stack).orElse(null);
            if (cfg == null) {
                return weight;
            }
            int level = gearData.getItemLevel();
            ArrayList modifiers = new ArrayList();
            modifiers.addAll(gearData.getModifiers(VaultGearModifier.AffixType.PREFIX));
            modifiers.addAll(gearData.getModifiers(VaultGearModifier.AffixType.SUFFIX));
            ArrayList rangePercentage = new ArrayList();
            ArrayList weightsToAdd = new ArrayList();
            modifiers.forEach(mod -> {
                if (mod.getAttribute().getRegistryName().equals((Object)VaultMod.id((String)"hammer_size"))) {
                    weightsToAdd.add(50000);
                }
                if (mod.getAttribute().getRegistryName().equals((Object)VaultMod.id((String)"soulbound"))) {
                    weightsToAdd.add(25000);
                }
                VaultGearTierConfig.ModifierConfigRange range = cfg.getTierConfigRange(mod, level);
                ConfigurableAttributeGenerator generator = mod.getAttribute().getGenerator();
                generator.getRollPercentage(mod.getValue(), range.allTierConfigs()).ifPresent(value -> {
                    if (value instanceof Float) {
                        Float f = (Float)value;
                        rangePercentage.add(f);
                    }
                });
            });
            if (!rangePercentage.isEmpty()) {
                float avg = (float)rangePercentage.stream().mapToDouble(Float::doubleValue).average().orElse(1.0);
                weight += (int)(avg * 1000.0f);
            }
            for (Integer value : weightsToAdd) {
                weight += value.intValue();
            }
            return weight;
        }
        return 0;
    }
}

