/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.fixes;

import com.llamalad7.mixinextras.sugar.Local;
import iskallia.vault.VaultMod;
import iskallia.vault.client.ClientExpertiseData;
import iskallia.vault.config.recipe.ForgeRecipeType;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.crafting.recipe.JewelCraftingRecipe;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.IdentifiableItem;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.util.LootInitialization;
import iskallia.vault.world.data.PlayerExpertisesData;
import java.util.List;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.iwolfking.woldsvaults.WoldsVaults;
import xyz.iwolfking.woldsvaults.data.discovery.ClientRecipeDiscoveryData;
import xyz.iwolfking.woldsvaults.data.discovery.DiscoveredRecipesData;
import xyz.iwolfking.woldsvaults.init.ModConfigs;

@Mixin(value={JewelCraftingRecipe.class}, remap=false)
public abstract class MixinJewelCraftingRecipe
extends VaultForgeRecipe {
    @Unique
    private static final Set<ResourceLocation> CRAFTABLE_UNIQUE_JEWELS = Set.of(WoldsVaults.id("treasure_jewel"), WoldsVaults.id("shattering_jewel"));

    protected MixinJewelCraftingRecipe(ForgeRecipeType type, ResourceLocation id, ItemStack output) {
        super(type, id, output);
    }

    public boolean canCraft(Player player) {
        if (this.getId().equals((Object)VaultMod.id((String)"random"))) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ExpertiseTree tree = PlayerExpertisesData.get((MinecraftServer)serverPlayer.f_8924_).getExpertises(player);
                for (Skill skill : tree.skills) {
                    if (!skill.getId().equals("Jeweler")) continue;
                    return skill.isUnlocked();
                }
            } else {
                TieredSkill expertise = ClientExpertiseData.getLearnedTalentNode((String)"Jeweler");
                return expertise != null && expertise.isUnlocked();
            }
        }
        if (ModConfigs.RECIPE_UNLOCKS.RECIPE_UNLOCKS.containsKey(this.getId())) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)player;
                return player.m_7500_() || DiscoveredRecipesData.get(sPlayer.f_8924_).hasDiscovered(player, this.getId());
            }
            return player.m_7500_() || ClientRecipeDiscoveryData.getDiscoveredRecipes().contains(this.getId());
        }
        return true;
    }

    @Redirect(method={"createAttributeJewel"}, at=@At(value="INVOKE", target="Liskallia/vault/gear/data/VaultGearData;addModifier(Liskallia/vault/gear/attribute/VaultGearModifier$AffixType;Liskallia/vault/gear/attribute/VaultGearModifier;)Z", ordinal=1))
    private static boolean createAttributeJewel(VaultGearData instance, VaultGearModifier.AffixType type, VaultGearModifier<?> modifier, @Local VaultGearAttribute<?> attribute) {
        if (attribute != null && attribute.getRegistryName().equals((Object)VaultMod.id((String)"immortality"))) {
            return instance.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier(attribute, (Object)Float.valueOf(0.2f)));
        }
        return instance.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier(attribute, (Object)true));
    }

    @Inject(method={"createJewel"}, at={@At(value="HEAD")}, cancellable=true)
    private void createUniqueJewel(int vaultLevel, CallbackInfoReturnable<ItemStack> cir) {
        if (CRAFTABLE_UNIQUE_JEWELS.contains(this.getId())) {
            cir.setReturnValue((Object)this.woldsVaults$createUniqueJewel(vaultLevel));
        }
    }

    @Inject(method={"getDisplayOutput"}, at={@At(value="HEAD")}, cancellable=true)
    private void displayUniqueJewel(int vaultLevel, CallbackInfoReturnable<ItemStack> cir) {
        if (CRAFTABLE_UNIQUE_JEWELS.contains(this.getId())) {
            cir.setReturnValue((Object)this.woldsVaults$createUniqueJewel(vaultLevel));
        }
    }

    @Unique
    private ItemStack woldsVaults$createUniqueJewel(int vaultLevel) {
        ItemStack stack = this.getRawOutput();
        VaultGearData data = VaultGearData.read((ItemStack)stack);
        data.setItemLevel(vaultLevel);
        data.setRarity(VaultGearRarity.UNIQUE);
        data.createOrReplaceAttributeValue(ModGearAttributes.GEAR_ROLL_TYPE, (Object)"Unique");
        ResourceLocation pool = iskallia.vault.init.ModConfigs.UNIQUE_GEAR.findPoolForUnique(this.getId()).orElse(null);
        if (pool != null) {
            data.createOrReplaceAttributeValue(ModGearAttributes.GEAR_UNIQUE_POOL, (Object)pool);
            data.write(stack);
            stack = LootInitialization.initializeVaultLoot((ItemStack)stack, (int)vaultLevel);
            Item item = stack.m_41720_();
            if (item instanceof IdentifiableItem) {
                IdentifiableItem identifiableItem = (IdentifiableItem)item;
                identifiableItem.instantIdentify(null, stack);
            }
        }
        return stack;
    }

    public List<Component> getDisabledText() {
        if (ModConfigs.RECIPE_UNLOCKS.RECIPE_UNLOCKS.containsKey(this.getId())) {
            return List.of(new TextComponent(ModConfigs.RECIPE_UNLOCKS.RECIPE_UNLOCKS.get((Object)this.getId()).DESCRIPTION));
        }
        if (this.getId().equals((Object)VaultMod.id((String)"random"))) {
            return List.of(new TextComponent("Random Jewel Crafting - Unlocked by the Jeweler Expertise"));
        }
        return super.getDisabledText();
    }
}

