/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.fixes;

import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.ScheduledModifiers;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.gear.attribute.talent.RandomVaultModifierAttribute;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ScheduledModifiers.class}, remap=false)
public class MixinScheduledModifiers {
    @Shadow
    @Final
    private List<ScheduledModifiers.Entry> cache;

    @Overwrite
    public void onJoin(Vault vault, ServerPlayer player) {
        int activationTime;
        if (VaultUtils.isRoyaleVault((Vault)vault) || VaultUtils.isPvPVault((Vault)vault) || VaultUtils.isHeraldVault((Vault)vault)) {
            return;
        }
        JavaRandom random = JavaRandom.ofScrambled((long)(player.m_142081_().getLeastSignificantBits() ^ ((UUID)vault.get(Vault.ID)).getMostSignificantBits()));
        int logicalTime = (Integer)((TickClock)vault.get(Vault.CLOCK)).get(TickClock.LOGICAL_TIME);
        int displayTime = (Integer)((TickClock)vault.get(Vault.CLOCK)).get(TickClock.DISPLAY_TIME);
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player);
        for (RandomVaultModifierAttribute attribute : (List)snapshot.getAttributeValue(ModGearAttributes.RANDOM_VAULT_MODIFIER, VaultGearAttributeTypeMerger.asList())) {
            activationTime = random.nextInt(logicalTime + displayTime);
            this.cache.add(new ScheduledModifiers.Entry(attribute.getModifier(), attribute.getCount(), Integer.valueOf(attribute.getTime()), activationTime).setVaultGod(VaultGod.IDONA));
        }
        for (RandomVaultModifierAttribute attribute : (List)snapshot.getAttributeValue(ModGearAttributes.RANDOM_VAULT_GOD_MODIFIER, VaultGearAttributeTypeMerger.asList())) {
            activationTime = random.nextInt(logicalTime + displayTime);
            this.cache.add(new ScheduledModifiers.Entry(attribute.getModifier(), attribute.getCount(), Integer.valueOf(attribute.getTime()), activationTime).setVaultGod(attribute.getVaultGod()));
        }
    }
}

