/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.fixes;

import iskallia.vault.command.GearDebugCommand;
import iskallia.vault.config.UniqueGearConfig;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.iwolfking.vhapi.api.util.ResourceLocUtils;

@Mixin(value={GearDebugCommand.class}, remap=false)
public class MixinUniqueGearCommand {
    @Inject(method={"findPoolForUniqueItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void fixUniqueNameHandling(ResourceLocation uniqueId, CallbackInfoReturnable<ResourceLocation> cir) {
        ResourceLocation dedicatedPool;
        Map pools = ModConfigs.UNIQUE_GEAR.getPools();
        if (pools.containsKey(dedicatedPool = new ResourceLocation("woldsvaults", uniqueId.m_135815_()))) {
            cir.setReturnValue((Object)dedicatedPool);
        }
    }

    @Redirect(method={"giveUniqueItemByName"}, at=@At(value="INVOKE", target="Liskallia/vault/config/UniqueGearConfig;getEntry(Lnet/minecraft/resources/ResourceLocation;)Ljava/util/Optional;"))
    private Optional<UniqueGearConfig.Entry> testForWoldsUnique(UniqueGearConfig instance, ResourceLocation id) {
        ResourceLocation woldsId;
        if (ModConfigs.UNIQUE_GEAR.getEntry(id).isEmpty() && ModConfigs.UNIQUE_GEAR.getEntry(woldsId = ResourceLocUtils.swapNamespace((ResourceLocation)id, (String)"woldsvaults")).isPresent()) {
            return ModConfigs.UNIQUE_GEAR.getEntry(woldsId);
        }
        return ModConfigs.UNIQUE_GEAR.getEntry(id);
    }

    @Inject(method={"determineItemStackForUnique"}, at={@At(value="HEAD")}, cancellable=true)
    private void addAdditionalItemStacksForUniques(UniqueGearConfig.Entry uniqueEntry, CallbackInfoReturnable<ItemStack> cir) {
        ResourceLocation model = uniqueEntry.getModel();
        if (model != null) {
            String modelPath = model.m_135815_();
            if (modelPath.contains("jewel")) {
                cir.setReturnValue((Object)new ItemStack((ItemLike)ModItems.JEWEL));
            } else if (modelPath.contains("magnet")) {
                cir.setReturnValue((Object)new ItemStack((ItemLike)ModItems.MAGNET));
            } else if (modelPath.contains("battlestaff")) {
                cir.setReturnValue((Object)new ItemStack((ItemLike)xyz.iwolfking.woldsvaults.init.ModItems.BATTLESTAFF));
            } else if (modelPath.contains("trident")) {
                cir.setReturnValue((Object)new ItemStack((ItemLike)xyz.iwolfking.woldsvaults.init.ModItems.TRIDENT));
            } else if (modelPath.contains("rang")) {
                cir.setReturnValue((Object)new ItemStack((ItemLike)xyz.iwolfking.woldsvaults.init.ModItems.RANG));
            } else if (modelPath.contains("plushie")) {
                cir.setReturnValue((Object)new ItemStack((ItemLike)xyz.iwolfking.woldsvaults.init.ModItems.PLUSHIE));
            } else if (modelPath.contains("loot_sack")) {
                cir.setReturnValue((Object)new ItemStack((ItemLike)xyz.iwolfking.woldsvaults.init.ModItems.LOOT_SACK));
            }
        }
    }
}

