/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.fixes;

import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.gear.VaultGearModifierHelper;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.comparator.VaultGearAttributeComparator;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.modification.GearModification;
import iskallia.vault.util.MiscUtils;
import java.util.List;
import java.util.Random;
import java.util.random.RandomGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={VaultGearModifierHelper.class}, remap=false, priority=1500)
public abstract class MixinVaultGearModifierHelper {
    @Overwrite
    public static GearModification.Result reForgeOutcomeOfRandomModifier(ItemStack stack, long worldGameTime, Random random) {
        VaultGearData data = VaultGearData.read((ItemStack)stack);
        if (!data.isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        List<Tuple<VaultGearModifier<?>, WeightedList<VaultGearTierConfig.ModifierOutcome<?>>>> modifierReplacements = MixinVaultGearModifierHelper.getAvailableModifierConfigurationOutcomes(data, stack, true);
        if (modifierReplacements == null) {
            return GearModification.Result.errorInternal();
        }
        modifierReplacements.removeIf(tpl -> {
            if (((VaultGearModifier)tpl.m_14418_()).hasCategory(VaultGearModifier.AffixCategory.valueOf((String)"UNUSUAL"))) {
                return true;
            }
            return ((WeightedList)tpl.m_14419_()).size() <= 1;
        });
        if (modifierReplacements.isEmpty()) {
            return GearModification.Result.makeActionError((String)"no_modifiers", (Component[])new Component[0]);
        }
        Tuple potentialReplacements = (Tuple)MiscUtils.getRandomEntry(modifierReplacements);
        if (potentialReplacements == null) {
            return GearModification.Result.errorInternal();
        }
        VaultGearTierConfig.ModifierOutcome replacement = ((WeightedList)potentialReplacements.m_14419_()).getRandom((RandomGenerator)random).orElse(null);
        if (replacement == null) {
            return GearModification.Result.errorInternal();
        }
        VaultGearModifier existing = (VaultGearModifier)potentialReplacements.m_14418_();
        VaultGearModifier newModifier = replacement.makeModifier(random);
        VaultGearAttributeComparator comparator = existing.getAttribute().getAttributeComparator();
        if (comparator != null && comparator.compare(existing.getValue(), newModifier.getValue()) == 0) {
            return MixinVaultGearModifierHelper.reForgeOutcomeOfRandomModifier(stack, worldGameTime, random);
        }
        data.getAllModifierAffixes().forEach(VaultGearModifier::resetGameTimeAdded);
        existing.setValue(newModifier.getValue());
        existing.setRolledTier(newModifier.getRolledTier());
        existing.setGameTimeAdded(worldGameTime);
        existing.clearCategories();
        data.write(stack);
        return GearModification.Result.makeSuccess();
    }

    @Overwrite
    public static GearModification.Result improveRandomModifier(ItemStack stack, long worldGameTime, Random random) {
        try {
            VaultGearModifier newModifier;
            VaultGearData data = VaultGearData.read((ItemStack)stack);
            if (!data.isModifiable()) {
                return GearModification.Result.errorUnmodifiable();
            }
            List<Tuple<VaultGearModifier<?>, WeightedList<VaultGearTierConfig.ModifierOutcome<?>>>> modifierReplacements = MixinVaultGearModifierHelper.getAvailableModifierConfigurationOutcomes(data, stack, true);
            if (modifierReplacements == null) {
                return GearModification.Result.errorInternal();
            }
            modifierReplacements.removeIf(tpl -> {
                VaultGearModifier existing = (VaultGearModifier)tpl.m_14418_();
                if (existing.hasCategory(VaultGearModifier.AffixCategory.valueOf((String)"UNUSUAL"))) {
                    return true;
                }
                VaultGearAttributeComparator comparator = existing.getAttribute().getAttributeComparator();
                if (comparator == null) {
                    return true;
                }
                ConfigurableAttributeGenerator generator = existing.getAttribute().getGenerator();
                ((WeightedList)tpl.m_14419_()).entrySet().removeIf(weightedOutcome -> {
                    VaultGearTierConfig.ModifierOutcome outcome = (VaultGearTierConfig.ModifierOutcome)weightedOutcome.getKey();
                    Object tierConfig = outcome.tier().getModifierConfiguration();
                    Object maxValue = generator.getMaximumValue(List.of(tierConfig)).orElse(null);
                    if (maxValue == null) {
                        return true;
                    }
                    return comparator.compare(maxValue, existing.getValue()) <= 0;
                });
                return ((WeightedList)tpl.m_14419_()).isEmpty() || ((WeightedList)tpl.m_14419_()).entrySet().stream().allMatch(weightedOutcome -> {
                    VaultGearTierConfig.ModifierOutcome outcome = (VaultGearTierConfig.ModifierOutcome)weightedOutcome.getKey();
                    Object tierConfig = outcome.tier().getModifierConfiguration();
                    Object minValue = generator.getMinimumValue(List.of(tierConfig)).orElse(null);
                    Object maxValue = generator.getMaximumValue(List.of(tierConfig)).orElse(null);
                    if (minValue != null && maxValue != null) {
                        return comparator.compare(minValue, existing.getValue()) == 0 && comparator.compare(maxValue, existing.getValue()) == 0;
                    }
                    return true;
                });
            });
            if (modifierReplacements.isEmpty()) {
                return GearModification.Result.makeActionError((String)"all_max", (Component[])new Component[0]);
            }
            Tuple potentialReplacements = (Tuple)MiscUtils.getRandomEntry(modifierReplacements);
            if (potentialReplacements == null) {
                return GearModification.Result.errorInternal();
            }
            VaultGearTierConfig.ModifierOutcome replacement = ((WeightedList)potentialReplacements.m_14419_()).getRandom((RandomGenerator)random).orElse(null);
            if (replacement == null) {
                return GearModification.Result.errorInternal();
            }
            VaultGearModifier existing = (VaultGearModifier)potentialReplacements.m_14418_();
            VaultGearAttributeComparator comparator = existing.getAttribute().getAttributeComparator();
            if (comparator == null) {
                return GearModification.Result.errorInternal();
            }
            int i = 0;
            do {
                newModifier = replacement.makeModifier(random);
                if (++i <= 100) continue;
                if (newModifier.getValue().getClass().isInstance(Integer.class)) {
                    newModifier.setValue((Object)((Integer)newModifier.getValue() + 1));
                    break;
                }
                if (newModifier.getValue().getClass().isInstance(Float.class)) {
                    newModifier.setValue((Object)Float.valueOf(((Float)newModifier.getValue()).floatValue() + 0.01f));
                    break;
                }
                if (!newModifier.getValue().getClass().isInstance(Double.class)) break;
                newModifier.setValue((Object)((Double)newModifier.getValue() + 0.01));
                break;
            } while (comparator.compare(existing.getValue(), newModifier.getValue()) >= 0);
            data.getAllModifierAffixes().forEach(VaultGearModifier::resetGameTimeAdded);
            existing.setValue(newModifier.getValue());
            existing.setRolledTier(newModifier.getRolledTier());
            existing.setGameTimeAdded(worldGameTime);
            existing.clearCategories();
            data.write(stack);
            return GearModification.Result.makeSuccess();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Shadow
    private static List<Tuple<VaultGearModifier<?>, WeightedList<VaultGearTierConfig.ModifierOutcome<?>>>> getAvailableModifierConfigurationOutcomes(VaultGearData data, ItemStack stack, boolean includeOnlyModifiableModifiers) {
        return null;
    }
}

