/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.mixins.vaulthunters.skills.modifications;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.EntityStunnedEvent;
import iskallia.vault.entity.entity.IceBoltEntity;
import iskallia.vault.gear.attribute.ability.special.base.ConfiguredModification;
import iskallia.vault.gear.attribute.ability.special.base.SpecialAbilityModification;
import iskallia.vault.gear.attribute.ability.special.base.template.value.IntValue;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.StonefallFrostParticleMessage;
import iskallia.vault.skill.ability.effect.IceBoltChunkAbility;
import iskallia.vault.skill.ability.effect.spi.AbstractIceBoltAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.AABBHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import xyz.iwolfking.woldsvaults.modifiers.gear.special.GlacialBlastModification;

@Mixin(value={IceBoltChunkAbility.class}, remap=false)
public abstract class MixinIceBoltChunkAbility
extends AbstractIceBoltAbility {
    @Shadow
    private float glacialChance;

    @Shadow
    public abstract float getRadius(Entity var1);

    @Shadow
    public abstract int getDurationTicks(LivingEntity var1);

    @Shadow
    public abstract int getAmplifier();

    @Overwrite
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            IceBoltEntity arrow = new IceBoltEntity((LivingEntity)player, IceBoltEntity.Model.CHUNK, result -> {
                float radius = this.getRadius((Entity)player);
                Vec3 pos = result.m_82450_();
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new StonefallFrostParticleMessage(pos, this.getRadius((Entity)player)));
                player.f_19853_.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, ModSounds.NOVA_SPEED, SoundSource.PLAYERS, 0.2f, 1.0f);
                List nearbyEntities = player.f_19853_.m_45971_(LivingEntity.class, TargetingConditions.m_148352_().m_26888_(entity -> !(entity instanceof Player)).m_26883_(1000.0), (LivingEntity)player, AABBHelper.create((Vec3)pos, (float)radius));
                int hypothermia = 1;
                for (ConfiguredModification mod : SpecialAbilityModification.getModifications((LivingEntity)player, GlacialBlastModification.class)) {
                    hypothermia = ((IntValue)mod.value()).getValue();
                }
                if (hypothermia < 1) {
                    hypothermia = 1;
                }
                for (LivingEntity nearbyEntity : nearbyEntities) {
                    nearbyEntity.m_7292_(new MobEffectInstance(ModEffects.CHILLED, this.getDurationTicks((LivingEntity)player), this.getAmplifier(), false, false, false));
                    CommonEvents.ENTITY_STUNNED.invoke((Object)new EntityStunnedEvent.Data((LivingEntity)player, nearbyEntity));
                    if (!(player.f_19853_.f_46441_.nextFloat() <= this.glacialChance * (float)hypothermia)) continue;
                    nearbyEntity.m_21195_(ModEffects.GLACIAL_SHATTER);
                    nearbyEntity.m_7292_(new MobEffectInstance(ModEffects.GLACIAL_SHATTER, this.getDurationTicks((LivingEntity)player), this.getAmplifier()));
                    player.f_19853_.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11983_, SoundSource.BLOCKS, 0.25f, 0.65f);
                }
            });
            arrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, this.getThrowPower(), 0.0f);
            player.f_19853_.m_7967_((Entity)arrow);
            player.f_19853_.m_6269_(null, (Entity)player, ModSounds.ICE_BOLT_CHUNK, SoundSource.PLAYERS, 1.0f, player.f_19853_.f_46441_.nextFloat() * 0.3f + 0.9f);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    private static void setAbilityData(LivingEntity livingEntity, int intervalTicks, UUID playerUUID) {
        CompoundTag abilityData = MixinIceBoltChunkAbility.getAbilityData(livingEntity);
        abilityData.m_128405_("intervalTicks", intervalTicks);
        abilityData.m_128405_("remainingIntervalTicks", 0);
        abilityData.m_128362_("playerUUID", playerUUID);
    }

    private static CompoundTag getAbilityData(LivingEntity livingEntity) {
        CompoundTag persistentData = livingEntity.getPersistentData();
        CompoundTag abilityData = persistentData.m_128469_("the_vault:ability/Nova_Slow");
        persistentData.m_128365_("the_vault:ability/Nova_Slow", (Tag)abilityData);
        return abilityData;
    }
}

