/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.modifiers.vault;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.world.VaultDifficulty;
import iskallia.vault.world.data.WorldSettings;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.EventPriority;
import xyz.iwolfking.woldsvaults.init.ModGameRules;
import xyz.iwolfking.woldsvaults.mixins.vaulthunters.accessors.VaultDifficultyAccessor;

public class DifficultyLockModifier
extends VaultModifier<Properties> {
    private final Map<UUID, VaultDifficulty> RETURN_DIFFICULTY_MAP = new HashMap<UUID, VaultDifficulty>();

    public DifficultyLockModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, (Object)properties, display);
    }

    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        if (world.m_46469_().m_46207_(ModGameRules.NORMALIZED_ENABLED)) {
            CommonEvents.PLAYER_TICK.register((Object)context.getUUID(), EventPriority.HIGHEST, event -> {
                if (event.side.isServer()) {
                    if (event.player.f_19797_ % 20 != 0) {
                        return;
                    }
                    if (!event.player.m_183503_().m_46472_().equals((Object)world.m_46472_())) {
                        return;
                    }
                    if (((TickClock)vault.get(Vault.CLOCK)).has(TickClock.PAUSED)) {
                        return;
                    }
                    if (event.player.m_142081_() != vault.get(Vault.OWNER)) {
                        return;
                    }
                    if (WorldSettings.get((Level)world).getPlayerDifficulty((UUID)vault.get(Vault.OWNER)).equals((Object)((Properties)this.properties).getDifficulty())) {
                        return;
                    }
                    if (!((Properties)this.properties()).shouldLockHigher() && this.isDifficultyHigher(world, vault)) {
                        return;
                    }
                    if (!this.RETURN_DIFFICULTY_MAP.containsKey(vault.get(Vault.OWNER))) {
                        this.RETURN_DIFFICULTY_MAP.put((UUID)vault.get(Vault.OWNER), WorldSettings.get((Level)world).getPlayerDifficulty((UUID)vault.get(Vault.OWNER)));
                    }
                    WorldSettings.get((Level)world).setPlayerDifficulty((UUID)vault.get(Vault.OWNER), ((Properties)this.properties).getDifficulty());
                }
            });
        }
    }

    public void onListenerRemove(VirtualWorld world, Vault vault, ModifierContext context, Listener listener) {
        ServerPlayer player;
        UUID playerId;
        if (listener.getPlayer().isPresent() && this.RETURN_DIFFICULTY_MAP.containsKey(playerId = (player = (ServerPlayer)listener.getPlayer().get()).m_142081_())) {
            WorldSettings.get((Level)world).setPlayerDifficulty(playerId, this.RETURN_DIFFICULTY_MAP.get(playerId));
            this.RETURN_DIFFICULTY_MAP.remove(playerId);
        }
    }

    private boolean isDifficultyHigher(VirtualWorld world, Vault vault) {
        return ((VaultDifficultyAccessor)WorldSettings.get((Level)world).getPlayerDifficulty((UUID)vault.get(Vault.OWNER))).getDisplayOrder() >= ((VaultDifficultyAccessor)((Properties)this.properties).getDifficulty()).getDisplayOrder();
    }

    public static class Properties {
        @Expose
        private final String difficulty;
        @Expose
        private final boolean lockHigher;

        public Properties(String difficulty, boolean lockHigher) {
            this.difficulty = difficulty;
            this.lockHigher = lockHigher;
        }

        public VaultDifficulty getDifficulty() {
            return VaultDifficulty.valueOf((String)this.difficulty);
        }

        public boolean shouldLockHigher() {
            return this.lockHigher;
        }
    }
}

