/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.modifiers.vault;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.world.storage.VirtualWorld;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.EventPriority;
import xyz.iwolfking.woldsvaults.api.core.vault_events.VaultEvent;
import xyz.iwolfking.woldsvaults.objectives.data.EnchantedEventsRegistry;

public class EnchantedVaultModifier
extends VaultModifier<Properties> {
    public EnchantedVaultModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, (Object)properties, display);
    }

    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.PLAYER_TICK.register((Object)context.getUUID(), EventPriority.HIGHEST, event -> {
            if (event.side.isServer()) {
                if (event.player.f_19797_ % ((Properties)this.properties).getTicksPerCheck() != 0) {
                    return;
                }
                if (!event.player.m_183503_().m_46472_().equals((Object)world.m_46472_())) {
                    return;
                }
                if (((TickClock)vault.get(Vault.CLOCK)).has(TickClock.PAUSED)) {
                    return;
                }
                if (event.player.m_21187_().nextDouble() < ((Properties)this.properties).getChance() && EnchantedEventsRegistry.getEvents().getRandom().isPresent()) {
                    ((VaultEvent)EnchantedEventsRegistry.getEvents().getRandom().get()).triggerEvent(() -> ((Player)event.player).m_20097_(), (ServerPlayer)event.player, vault, false, VaultEvent.EventDisplayType.LEGACY);
                }
            }
        });
    }

    public static class Properties {
        @Expose
        private final double chance;
        @Expose
        private final int ticksPerCheck;

        public Properties(double chance, int ticksPerCheck) {
            this.chance = chance;
            this.ticksPerCheck = ticksPerCheck;
        }

        public double getChance() {
            return this.chance;
        }

        public int getTicksPerCheck() {
            return this.ticksPerCheck;
        }
    }
}

