/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.modifiers.vault;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import com.google.gson.annotations.Expose;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.eventbus.api.EventPriority;
import xyz.iwolfking.woldsvaults.objectives.data.BrutalBossesRegistry;

public class InfernalMobModifier
extends VaultModifier<Properties> {
    public InfernalMobModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, (Object)properties, display);
        this.setDescriptionFormatter((t, p, s) -> t.formatted((int)Math.abs(p.getChance() * (double)s * 100.0)));
    }

    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.ENTITY_SPAWN.register((Object)context.getUUID(), EventPriority.HIGHEST, event -> {
            Random random;
            LivingEntity entity;
            Entity spawnedEntity;
            if (event.getEntity().f_19853_ == world && (spawnedEntity = event.getEntity()) instanceof LivingEntity && ((Properties)this.properties).filter.test((Entity)(entity = (LivingEntity)spawnedEntity)) && (random = entity.f_19853_.m_5822_()).nextDouble() < ((Properties)this.properties).getChance()) {
                InfernalMobsCore.instance().addEntityModifiersByString(entity, BrutalBossesRegistry.getRandomMobModifiers(((Properties)this.properties).getAmount(), false));
            }
        });
    }

    public static class Properties {
        @Expose
        private final EntityPredicate filter;
        @Expose
        private final double chance;
        @Expose
        private final int amount;

        public Properties(EntityPredicate filter, double chance, int amount) {
            this.filter = filter;
            this.chance = chance;
            this.amount = amount;
        }

        public EntityPredicate getFilter() {
            return this.filter;
        }

        public double getChance() {
            return this.chance;
        }

        public int getAmount() {
            return this.amount;
        }
    }
}

