/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.modifiers.vault;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.CustomEntitySpawnerConfig;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.util.data.WeightedList;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.registries.ForgeRegistries;

public class MobDeathBombModifier
extends VaultModifier<Properties> {
    public MobDeathBombModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, (Object)properties, display);
    }

    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.ENTITY_DEATH.register((Object)context.getUUID(), EventPriority.HIGHEST, event -> {
            Entity spawnedEntity;
            if (event.getEntity().f_19853_ == world && (spawnedEntity = event.getEntity()) instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)spawnedEntity;
                if (((Properties)this.properties()).getShouldFilterExclude() && ((Properties)this.properties).filter.test((Entity)entity)) {
                    return;
                }
                Random random = entity.f_19853_.m_5822_();
                if (random.nextDouble() < ((Properties)this.properties).getChance()) {
                    int amountToSpawn = (Integer)((Properties)this.properties).getAmounts().getRandom(random);
                    for (int i = 0; i < amountToSpawn; ++i) {
                        Entity toSpawn;
                        EntityType typeToSpawn = (EntityType)ForgeRegistries.ENTITIES.getValue(((CustomEntitySpawnerConfig.SpawnerEntity)((Properties)this.properties).getEntities().getRandom((Random)random)).type);
                        if (typeToSpawn == null || (toSpawn = typeToSpawn.m_20615_((Level)world)) == null) continue;
                        toSpawn.m_146884_(entity.m_146892_());
                        world.m_7967_(toSpawn);
                    }
                }
            }
        });
    }

    public static class Properties {
        @Expose
        private final EntityPredicate filter;
        @Expose
        private final boolean filterShouldExclude;
        @Expose
        private final double chance;
        @Expose
        private final WeightedList<Integer> amounts;
        @Expose
        private final WeightedList<CustomEntitySpawnerConfig.SpawnerEntity> entities;

        public Properties(EntityPredicate filter, boolean filterShouldExclude, double chance, WeightedList<Integer> amounts, WeightedList<CustomEntitySpawnerConfig.SpawnerEntity> entities) {
            this.filter = filter;
            this.filterShouldExclude = filterShouldExclude;
            this.chance = chance;
            this.amounts = amounts;
            this.entities = entities;
        }

        public EntityPredicate getFilter() {
            return this.filter;
        }

        public double getChance() {
            return this.chance;
        }

        public boolean getShouldFilterExclude() {
            return this.filterShouldExclude;
        }

        public WeightedList<Integer> getAmounts() {
            return this.amounts;
        }

        public WeightedList<CustomEntitySpawnerConfig.SpawnerEntity> getEntities() {
            return this.entities;
        }
    }
}

