/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.modifiers.vault;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.CustomEntitySpawnerConfig;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.util.data.WeightedList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.registries.ForgeRegistries;

public class RetroSpawnVaultModifier
extends VaultModifier<Properties> {
    public RetroSpawnVaultModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, (Object)properties, display);
    }

    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.PLAYER_TICK.register((Object)context.getUUID(), EventPriority.HIGHEST, event -> {
            if (event.side.isServer()) {
                if (event.player.f_19797_ % ((Properties)this.properties).getTicksPerCheck() != 0) {
                    return;
                }
                if (((TickClock)vault.get(Vault.CLOCK)).has(TickClock.PAUSED)) {
                    return;
                }
                if (event.player.m_21187_().nextDouble() < ((Properties)this.properties).getChance()) {
                    if (!event.player.m_183503_().m_46472_().equals((Object)world.m_46472_())) {
                        return;
                    }
                    for (int i = 0; i < (Integer)((Properties)this.properties).amounts.getRandom(event.player.m_21187_()); ++i) {
                        int livingEntitiesAroundCount = world.m_45976_(LivingEntity.class, new AABB(event.player.m_20097_()).m_82400_(48.0)).size();
                        if (((Properties)this.properties).cap < livingEntitiesAroundCount) {
                            return;
                        }
                        this.doSpawn((VirtualWorld)event.player.f_19853_, event.player.m_20097_(), event.player.m_21187_());
                    }
                }
            }
        });
    }

    public LivingEntity doSpawn(VirtualWorld world, BlockPos pos, Random random) {
        double min = 20.0;
        double max = 30.0;
        LivingEntity spawned = null;
        while (spawned == null) {
            double angle = Math.PI * 2 * random.nextDouble();
            double distance = Math.sqrt(random.nextDouble() * (max * max - min * min) + min * min);
            int x = (int)Math.ceil(distance * Math.cos(angle));
            int z = (int)Math.ceil(distance * Math.sin(angle));
            double xzRadius = Math.sqrt(x * x + z * z);
            double yRange = Math.sqrt(max * max - xzRadius * xzRadius);
            int y = random.nextInt((int)Math.ceil(yRange) * 2 + 1) - (int)Math.ceil(yRange);
            spawned = this.spawnMob(world, pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z, random);
        }
        return spawned;
    }

    @Nullable
    public LivingEntity spawnMob(VirtualWorld world, int x, int y, int z, Random random) {
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(((CustomEntitySpawnerConfig.SpawnerEntity)((Properties)this.properties).getEntities().getRandom((Random)random)).type);
        Entity entity = type != null ? type.m_20615_((Level)world) : null;
        BlockState state = world.m_8055_(new BlockPos(x, y - 1, z));
        if (entity == null || !state.m_60643_((BlockGetter)world, new BlockPos(x, y - 1, z), entity.m_6095_())) {
            return null;
        }
        AABB entityBox = entity.m_6095_().m_20585_((double)x + 0.5, (double)y, (double)z + 0.5);
        if (!world.m_45772_(entityBox)) {
            return null;
        }
        entity.m_7678_((double)((float)x + 0.5f), (double)((float)y + 0.2f), (double)((float)z + 0.5f), (float)(random.nextDouble() * 2.0 * Math.PI), 0.0f);
        world.m_8847_(entity);
        return (LivingEntity)entity;
    }

    public static class Properties {
        @Expose
        private final double chance;
        @Expose
        private final int ticksPerCheck;
        @Expose
        private final WeightedList<CustomEntitySpawnerConfig.SpawnerEntity> entities;
        @Expose
        private final WeightedList<Integer> amounts;
        @Expose
        private final int cap;

        public Properties(double chance, int ticksPerCheck, WeightedList<CustomEntitySpawnerConfig.SpawnerEntity> entities, WeightedList<Integer> amounts, int cap) {
            this.chance = chance;
            this.ticksPerCheck = ticksPerCheck;
            this.entities = entities;
            this.amounts = amounts;
            this.cap = cap;
        }

        public double getChance() {
            return this.chance;
        }

        public int getTicksPerCheck() {
            return this.ticksPerCheck;
        }

        public int getCap() {
            return this.cap;
        }

        public WeightedList<Integer> getAmounts() {
            return this.amounts;
        }

        public WeightedList<CustomEntitySpawnerConfig.SpawnerEntity> getEntities() {
            return this.entities;
        }
    }
}

