/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.modifiers.vault.lib;

import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import xyz.iwolfking.woldsvaults.modifiers.vault.lib.ValueProperty;

public abstract class SettableValueVaultModifier<P extends Properties>
extends VaultModifier<P> {
    public SettableValueVaultModifier(ResourceLocation id, P properties, VaultModifier.Display display) {
        super(id, properties, display);
        this.setDescriptionFormatter((t, p, s) -> t.formatted((int)Math.abs(p.getValue() * (float)s * 100.0f)));
    }

    public String getDisplayNameFormatted(int modifierStackSize) {
        return this.display.getDescriptionFormatted().map(descriptionFormatted -> Optional.ofNullable(this.descriptionFormatter).map(formatter -> formatter.format(descriptionFormatted, (Object)((Properties)this.properties), modifierStackSize)).orElse((String)descriptionFormatted)).orElse(this.getDisplayDescription());
    }

    public static class Properties {
        private ValueProperty value = new ValueProperty(0.0f);

        public float getValue() {
            return Objects.requireNonNullElseGet(this.value, () -> new ValueProperty(0.0f)).getValue();
        }

        public float getValue(ModifierContext context) {
            if (this.value != null) {
                return this.getValue();
            }
            return new ValueProperty(0.0f).getValue();
        }

        public void setValue(Float val) {
            this.value = new ValueProperty(val.floatValue());
        }
    }
}

