/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.modifiers.vault.map.modifiers;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.TemplateGenerationEvent;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.data.tile.TilePredicate;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import xyz.iwolfking.woldsvaults.modifiers.vault.lib.SettableValueVaultModifier;

public class CascadeDecoratorModifierSettable
extends SettableValueVaultModifier<Properties> {
    public CascadeDecoratorModifierSettable(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, properties, display);
        this.setDescriptionFormatter((t, p, s) -> t.formatted((int)Math.abs(p.getValue() * (float)s * 100.0f)));
    }

    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.SURFACE_GENERATION.in((ServerLevel)world).register((Object)context.getUUID(), data -> this.onGenerate(vault, (ServerLevelAccessor)data.getGenRegion(), (ChunkAccess)data.getChunk(), "generation"), -100);
        CommonEvents.TEMPLATE_GENERATION.in((LevelWriter)world).at(TemplateGenerationEvent.Phase.POST).register((Object)context.getUUID(), data -> {
            int chunkX = data.getChunkPos().f_45578_;
            int chunkZ = data.getChunkPos().f_45579_;
            if (data.getWorld().m_7232_(chunkX, chunkZ)) {
                ChunkAccess chunk = data.getWorld().m_6325_(chunkX, chunkZ);
                this.onGenerate(vault, data.getWorld(), chunk, "population");
            }
        }, -100);
    }

    public void onGenerate(Vault vault, ServerLevelAccessor world, ChunkAccess access, String phase) {
        ArrayList tiles = new ArrayList();
        ArrayList pending = new ArrayList();
        access.m_5928_().forEach(pos -> {
            PartialTile tile;
            BlockState state = world.m_8055_(pos);
            BlockEntity entity = world.m_7702_(pos);
            CompoundTag raw = access.m_8049_(pos);
            if (raw == null) {
                raw = new CompoundTag();
                raw.m_128405_("x", pos.m_123341_());
                raw.m_128405_("y", pos.m_123342_());
                raw.m_128405_("z", pos.m_123343_());
                access.m_5604_(raw);
            }
            if (!raw.m_128471_("cascade_duped") && (!raw.m_128441_("phase") || raw.m_128461_("phase").equals(phase)) && ((Properties)this.properties).filter.test(tile = PartialTile.of((PartialBlockState)PartialBlockState.of((BlockState)state), (PartialCompoundNbt)PartialCompoundNbt.of((BlockEntity)entity), (BlockPos)pos))) {
                tiles.add(tile);
                pending.add(raw);
            }
        });
        ChunkRandom random = ChunkRandom.any();
        for (int i = 0; i < tiles.size(); ++i) {
            PartialTile tile = ((PartialTile)tiles.get(i)).copy();
            CompoundTag raw = (CompoundTag)pending.get(i);
            if (raw.m_128425_("cascade_seed", 4)) {
                random.setSeed(raw.m_128454_("cascade_seed"));
            } else {
                random.setBlockSeed(((Long)vault.get(Vault.SEED)).longValue(), tile.getPos(), 237429473L);
            }
            for (float p = ((Properties)this.properties).getValue(); p > 0.0f && random.nextFloat() < p; p -= 1.0f) {
                BlockPos result = this.getValidPosition(world, tile.getPos(), access.m_7697_(), (RandomSource)random);
                if (result == null) continue;
                BlockState current = world.m_8055_(result);
                if (current.m_60795_()) {
                    tile.getState().set((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
                } else if (current.m_60734_() instanceof LiquidBlock) {
                    tile.getState().set((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                }
                tile.place((CommonLevelAccessor)world, result, 3);
                CompoundTag rawResult = access.m_8049_(result);
                if (rawResult == null) {
                    rawResult = new CompoundTag();
                    rawResult.m_128405_("x", result.m_123341_());
                    rawResult.m_128405_("y", result.m_123342_());
                    rawResult.m_128405_("z", result.m_123343_());
                    access.m_5604_(rawResult);
                }
                rawResult.m_128379_("cascade_duped", true);
            }
            raw.m_128356_("cascade_seed", random.getSeed());
            raw.m_128359_("phase", phase);
        }
    }

    public BlockPos getValidPosition(ServerLevelAccessor world, BlockPos origin, ChunkPos chunkPos, RandomSource random) {
        int index = 0;
        BlockPos result = null;
        for (int y = origin.m_123342_() - 3; y <= origin.m_123342_() + 3; ++y) {
            for (int x = origin.m_123341_() - 3; x <= origin.m_123341_() + 3; ++x) {
                for (int z = origin.m_123343_() - 3; z <= origin.m_123343_() + 3; ++z) {
                    if (x >> 4 != chunkPos.f_45578_ || z >> 4 != chunkPos.f_45579_) continue;
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = world.m_8055_(pos);
                    if (!world.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)world, pos, Direction.UP) || !state.m_60795_() && !(state.m_60734_() instanceof LiquidBlock) || random.nextInt(++index) != 0) continue;
                    result = pos;
                }
            }
        }
        return result;
    }

    public void releaseServer(ModifierContext context) {
        CommonEvents.SURFACE_GENERATION.release((Object)context.getUUID());
    }

    public static class Properties
    extends SettableValueVaultModifier.Properties {
        @Expose
        private final TilePredicate filter;

        public Properties(TilePredicate filter) {
            this.filter = filter;
        }

        public TilePredicate getFilter() {
            return this.filter;
        }
    }
}

