/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.modifiers.vault.map.modifiers;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.LootGenerationEvent;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.core.world.loot.generator.LootGenerator;
import iskallia.vault.core.world.loot.generator.TieredLootTableGenerator;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import xyz.iwolfking.woldsvaults.modifiers.vault.lib.SettableValueVaultModifier;

public class LootItemRarityModifierSettable
extends SettableValueVaultModifier<SettableValueVaultModifier.Properties> {
    public LootItemRarityModifierSettable(ResourceLocation id, SettableValueVaultModifier.Properties properties, VaultModifier.Display display) {
        super(id, properties, display);
        this.setDescriptionFormatter((t, p, s) -> t.formatted((int)Math.abs((double)p.getValue() * (double)s * 100.0)));
    }

    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.LOOT_GENERATION.pre().register((Object)context.getUUID(), data -> this.getGenerator(vault, (LootGenerationEvent.Data)data, context).ifPresent(generator -> {
            generator.itemRarity = (float)((double)generator.itemRarity + (double)((SettableValueVaultModifier.Properties)this.properties).getValue());
        }));
        CommonEvents.LOOT_GENERATION.post().register((Object)context.getUUID(), data -> this.getGenerator(vault, (LootGenerationEvent.Data)data, context).ifPresent(generator -> {
            generator.itemRarity = (float)((double)generator.itemRarity - (double)((SettableValueVaultModifier.Properties)this.properties).getValue());
        }));
    }

    public Optional<TieredLootTableGenerator> getGenerator(Vault vault, LootGenerationEvent.Data data, ModifierContext context) {
        LootGenerator var5 = data.getGenerator();
        if (var5 instanceof TieredLootTableGenerator) {
            TieredLootTableGenerator generator = (TieredLootTableGenerator)var5;
            if (generator.getSource() == null) {
                return Optional.empty();
            }
            UUID uuid = generator.getSource().m_142081_();
            if (!((Listeners)vault.get(Vault.LISTENERS)).contains(uuid)) {
                return Optional.empty();
            }
            return context.hasTarget() && !context.getTarget().equals(uuid) ? Optional.empty() : Optional.of(generator);
        }
        return Optional.empty();
    }
}

