/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.modifiers.vault.map.modifiers.lib;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.core.vault.modifier.spi.IVaultModifierTextFormatter;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.iwolfking.woldsvaults.modifiers.vault.lib.SettableValueVaultModifier;

public class EntityAttributeModifierSettable<P extends SettableValueVaultModifier.Properties>
extends SettableValueVaultModifier<Properties> {
    private final long leastSignificantBits = UUID.nameUUIDFromBytes(this.getId().toString().getBytes(StandardCharsets.UTF_8)).getLeastSignificantBits();

    public EntityAttributeModifierSettable(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, properties, display);
        if (properties.getType() != null) {
            this.setDescriptionFormatter(properties.getType().getDescriptionFormatter());
        } else {
            this.setDescriptionFormatter((t, p, s) -> t);
        }
    }

    public void applyToEntity(LivingEntity entity, UUID contextUUID, ModifierContext context) {
        ModifierType modifierType = ((Properties)this.properties).getType();
        List<ResourceLocation> ids = modifierType.getAttributeResourceLocations();
        for (ResourceLocation id : ids) {
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(id);
            UUID uuid = this.getId(contextUUID);
            if (attribute == null) {
                VaultMod.LOGGER.error("Invalid entity attribute '%s' configured for vault modifier '%s'".formatted(id, this.getId()));
                return;
            }
            AttributeInstance attributeInstance = entity.m_21051_(attribute);
            if (attributeInstance == null) {
                return;
            }
            AttributeModifier modifier = attributeInstance.m_22111_(uuid);
            double amount = ((Properties)this.properties).getValue();
            if (modifier != null) continue;
            attributeInstance.m_22125_(new AttributeModifier(uuid, this.getDisplayName(), amount, modifierType.getAttributeModifierOperation()));
        }
    }

    public void removeFromEntity(LivingEntity entity) {
        ModifierType modifierType = ((Properties)this.properties).getType();
        if (modifierType != null) {
            List<ResourceLocation> ids = modifierType.getAttributeResourceLocations();
            for (ResourceLocation attributeResourceLocation : ids) {
                Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeResourceLocation);
                if (attribute == null) {
                    VaultMod.LOGGER.error("Invalid entity attribute '%s' configured for vault modifier '%s'".formatted(attributeResourceLocation, this.getId()));
                    continue;
                }
                AttributeInstance attributeInstance = entity.m_21051_(attribute);
                if (attributeInstance == null) continue;
                HashSet attributeModifiers = new HashSet(attributeInstance.m_22122_());
                for (AttributeModifier modifier : attributeModifiers) {
                    if (!this.isId(modifier.m_22209_())) continue;
                    attributeInstance.m_22120_(modifier.m_22209_());
                }
            }
            return;
        }
    }

    protected UUID getId(UUID uuid) {
        return new UUID(uuid.getMostSignificantBits(), this.leastSignificantBits);
    }

    protected boolean isId(UUID uuid) {
        return uuid.getLeastSignificantBits() == this.leastSignificantBits;
    }

    public static class Properties
    extends SettableValueVaultModifier.Properties {
        @Expose
        private final ModifierType type;

        public Properties(ModifierType type) {
            this.type = type;
        }

        public ModifierType getType() {
            return this.type;
        }
    }

    public static enum ModifierType {
        MAX_HEALTH_ADDITIVE(List.of(new ResourceLocation("generic.max_health")), AttributeModifier.Operation.ADDITION, Constants.DESCRIPTION_FORMATTER_ADDITIVE_INT),
        MAX_HEALTH_ADDITIVE_PERCENTILE(List.of(new ResourceLocation("generic.max_health")), AttributeModifier.Operation.MULTIPLY_BASE, Constants.DESCRIPTION_FORMATTER_ADDITIVE_PERCENTILE),
        MAX_HEALTH_MULTIPLICATIVE_PERCENTILE(List.of(new ResourceLocation("generic.max_health")), AttributeModifier.Operation.MULTIPLY_TOTAL, Constants.DESCRIPTION_FORMATTER_MULTIPLICATIVE_PERCENTILE),
        ATTACK_DAMAGE_ADDITIVE_PERCENTILE(List.of(new ResourceLocation("generic.attack_damage")), AttributeModifier.Operation.MULTIPLY_BASE, Constants.DESCRIPTION_FORMATTER_ADDITIVE_PERCENTILE),
        SPEED_ADDITIVE_PERCENTILE(List.of(new ResourceLocation("generic.movement_speed"), new ResourceLocation("generic.flying_speed")), AttributeModifier.Operation.MULTIPLY_BASE, Constants.DESCRIPTION_FORMATTER_ADDITIVE_PERCENTILE),
        MANA_MAX_ADDITIVE(List.of(VaultMod.id((String)"generic.mana_max")), AttributeModifier.Operation.ADDITION, Constants.DESCRIPTION_FORMATTER_ADDITIVE),
        MANA_MAX_ADDITIVE_PERCENTILE(List.of(VaultMod.id((String)"generic.mana_max")), AttributeModifier.Operation.MULTIPLY_BASE, Constants.DESCRIPTION_FORMATTER_ADDITIVE_PERCENTILE),
        MANA_REGEN_ADDITIVE(List.of(VaultMod.id((String)"generic.mana_regen")), AttributeModifier.Operation.ADDITION, Constants.DESCRIPTION_FORMATTER_ADDITIVE),
        MANA_REGEN_ADDITIVE_PERCENTILE(List.of(VaultMod.id((String)"generic.mana_regen")), AttributeModifier.Operation.MULTIPLY_BASE, Constants.DESCRIPTION_FORMATTER_ADDITIVE_PERCENTILE),
        CRIT_CHANCE_ADDITIVE(List.of(VaultMod.id((String)"generic.crit_chance")), AttributeModifier.Operation.ADDITION, Constants.DESCRIPTION_FORMATTER_ADDITIVE),
        KNOCKBACK_RESISTANCE_ADDITIVE(List.of(new ResourceLocation("generic.knockback_resistance")), AttributeModifier.Operation.ADDITION, Constants.DESCRIPTION_FORMATTER_ADDITIVE),
        DURABILITY_WEAR_REDUCTION_CAP_ADDITIVE(List.of(new ResourceLocation("generic.durability_wear_reduction_cap")), AttributeModifier.Operation.ADDITION, Constants.DESCRIPTION_FORMATTER_ADDITIVE);

        private final List<ResourceLocation> attributeResourceLocations;
        private final AttributeModifier.Operation attributeModifierOperation;
        private final IVaultModifierTextFormatter<Properties> descriptionFormatter;

        private ModifierType(List attributeResourceLocations, AttributeModifier.Operation attributeModifierOperation, IVaultModifierTextFormatter descriptionFormatter) {
            this.attributeResourceLocations = attributeResourceLocations;
            this.attributeModifierOperation = attributeModifierOperation;
            this.descriptionFormatter = descriptionFormatter;
        }

        public List<ResourceLocation> getAttributeResourceLocations() {
            return this.attributeResourceLocations;
        }

        public AttributeModifier.Operation getAttributeModifierOperation() {
            return this.attributeModifierOperation;
        }

        public <P extends Properties> IVaultModifierTextFormatter<Properties> getDescriptionFormatter() {
            return this.descriptionFormatter;
        }

        private static class Constants {
            public static final IVaultModifierTextFormatter<Properties> DESCRIPTION_FORMATTER_ADDITIVE_INT = (t, p, s) -> t.formatted(Mth.m_14143_((float)Math.abs(p.getValue() * (float)s)));
            public static final IVaultModifierTextFormatter<Properties> DESCRIPTION_FORMATTER_ADDITIVE = (t, p, s) -> t.formatted(Mth.m_14107_((double)Math.abs((double)p.getValue() * (double)s * 100.0)));
            public static final IVaultModifierTextFormatter<Properties> DESCRIPTION_FORMATTER_ADDITIVE_PERCENTILE = (t, p, s) -> t.formatted((int)((double)Math.abs(p.getValue()) * (double)s * 100.0));
            public static final IVaultModifierTextFormatter<Properties> DESCRIPTION_FORMATTER_MULTIPLICATIVE_PERCENTILE = (t, p, s) -> t.formatted((int)((double)Math.abs(p.getValue()) * (double)s * 100.0));

            private Constants() {
            }
        }
    }
}

