/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.network.message;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import xyz.iwolfking.woldsvaults.client.particle.ElixirOrbParticle;

public class ElixirParticleMessage {
    private final int size;
    private final BlockPos blockPos;

    public ElixirParticleMessage(int size, BlockPos pos) {
        this.size = size;
        this.blockPos = pos;
    }

    public static void encode(ElixirParticleMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.size);
        buffer.m_130064_(message.blockPos);
    }

    public static ElixirParticleMessage decode(FriendlyByteBuf buffer) {
        return new ElixirParticleMessage(buffer.readInt(), buffer.m_130135_());
    }

    public static void handle(ElixirParticleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                message.spawnParticles();
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            ParticleEngine pe = Minecraft.m_91087_().f_91061_;
            for (int i = 0; i < Math.abs(this.size) / 2 + 3; ++i) {
                ElixirOrbParticle p = new ElixirOrbParticle(level, (double)this.blockPos.m_123341_() + 0.5, (double)this.blockPos.m_123342_() + 0.5, (double)this.blockPos.m_123343_() + 0.5, level.f_46441_.nextDouble() * 0.2 - 0.1, level.f_46441_.nextDouble() * 0.2, level.f_46441_.nextDouble() * 0.2 - 0.1, this.size);
                if (p instanceof ElixirOrbParticle) {
                    ElixirOrbParticle elixParticle = p;
                    elixParticle.setSize(this.size);
                }
                pe.m_107344_((Particle)p);
            }
        }
    }
}

