/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.objectives;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.VaultMod;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.IBitAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.data.key.registry.KeyRegistry;
import iskallia.vault.core.data.sync.handler.SyncHandler;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.stat.StatsCollector;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.entity.champion.ChampionLogic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import xyz.iwolfking.woldsvaults.api.util.GameruleHelper;
import xyz.iwolfking.woldsvaults.api.util.VaultModifierUtils;
import xyz.iwolfking.woldsvaults.blocks.tiles.BrewingAltarTileEntity;
import xyz.iwolfking.woldsvaults.config.AlchemyObjectiveConfig;
import xyz.iwolfking.woldsvaults.events.vaultevents.BrewingAltarBrewEvent;
import xyz.iwolfking.woldsvaults.events.vaultevents.WoldCommonEvents;
import xyz.iwolfking.woldsvaults.events.vaultevents.client.WoldClientEvents;
import xyz.iwolfking.woldsvaults.init.ModConfigs;
import xyz.iwolfking.woldsvaults.init.ModGameRules;
import xyz.iwolfking.woldsvaults.items.alchemy.AlchemyIngredientItem;
import xyz.iwolfking.woldsvaults.items.alchemy.CatalystItem;
import xyz.iwolfking.woldsvaults.objectives.data.alchemy.AlchemyTasks;

public class AlchemyObjective
extends Objective {
    public static final ResourceLocation HUD = VaultMod.id((String)"textures/gui/alchemy/hud.png");
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of((String)"alchemy", Objective.class).with(Version.v1_31, AlchemyObjective::new);
    private static final FieldRegistry FIELDS = (FieldRegistry)Objective.FIELDS.merge((KeyRegistry)new FieldRegistry());
    private static final FieldKey<Float> OBJECTIVE_PROBABILITY = (FieldKey)FieldKey.of((String)"objective_probability", Float.class).with(Version.v1_2, (IBitAdapter)Adapters.FLOAT, (SyncHandler)DISK.all()).register((KeyRegistry)FIELDS);
    private static final FieldKey<Float> PROGRESS = (FieldKey)FieldKey.of((String)"progress", Float.class).with(Version.v1_31, (IBitAdapter)Adapters.FLOAT, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
    private static final FieldKey<Float> REQUIRED_PROGRESS = (FieldKey)FieldKey.of((String)"required_progress", Float.class).with(Version.v1_31, (IBitAdapter)Adapters.FLOAT, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
    private static final FieldKey<Boolean> FULLY_OVERSTACKED = (FieldKey)FieldKey.of((String)"fully_overstacked", Boolean.class).with(Version.v1_31, (IBitAdapter)Adapters.BOOLEAN, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
    private static final FieldKey<Integer> OVERSTACK_ALLOWANCE = (FieldKey)FieldKey.of((String)"overstack_allowance", Integer.class).with(Version.v1_31, (IBitAdapter)Adapters.INT, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
    public static final FieldKey<Integer> VAULT_LEVEL = (FieldKey)FieldKey.of((String)"vault_level", Integer.class).with(Version.v1_31, (IBitAdapter)Adapters.INT_SEGMENTED_3, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
    private AlchemyObjectiveConfig.Entry config;

    protected AlchemyObjective() {
    }

    protected AlchemyObjective(float objectiveProbability, int vaultLevel, float requiredProgress) {
        Random random = new Random();
        this.set(OBJECTIVE_PROBABILITY, Float.valueOf(objectiveProbability));
        this.set(PROGRESS, Float.valueOf(0.0f));
        this.set(VAULT_LEVEL, vaultLevel);
        this.set(REQUIRED_PROGRESS, Float.valueOf(requiredProgress));
        this.set(FULLY_OVERSTACKED, false);
        this.set(OVERSTACK_ALLOWANCE, random.nextInt(100, 1001));
    }

    public static AlchemyObjective of(float objectiveProbability, int vaultLevel, float requiredProgress) {
        return new AlchemyObjective(objectiveProbability, vaultLevel, requiredProgress);
    }

    public void initClient(Vault vault) {
        this.config = ModConfigs.ALCHEMY_OBJECTIVE.getConfig((Integer)this.get(VAULT_LEVEL));
        WoldClientEvents.TOOLTIP_EVENT.register(vault, itemTooltipEvent -> {
            AlchemyIngredientItem ingredient;
            block13: {
                block12: {
                    Item patt5662$temp = itemTooltipEvent.getItemStack().m_41720_();
                    if (!(patt5662$temp instanceof AlchemyIngredientItem)) break block12;
                    ingredient = (AlchemyIngredientItem)patt5662$temp;
                    if (itemTooltipEvent.getItemStack().m_41783_() != null) break block13;
                }
                return;
            }
            if (!itemTooltipEvent.getItemStack().m_41783_().m_128461_("VaultId").equals(((UUID)vault.get(Vault.ID)).toString())) {
                return;
            }
            ArrayList<Object> tooltip = new ArrayList<Object>();
            switch (ingredient.getType()) {
                case VOLATILE: {
                    tooltip.add(new TextComponent("- ").m_7220_((Component)new TextComponent("Applies a ")).m_7220_((Component)new TextComponent("Strong ").m_130948_(Style.f_131099_.m_178520_(16209445))).m_7220_((Component)new TextComponent("Negative ").m_130948_(Style.f_131099_.m_178520_(0x910000))).m_7220_((Component)new TextComponent("Modifier and a ")).m_7220_((Component)new TextComponent("Strong ").m_130948_(Style.f_131099_.m_178520_(16209445))).m_7220_((Component)new TextComponent("Positive ").m_130948_(Style.f_131099_.m_178520_(3203076))).m_7220_((Component)new TextComponent("Modifier")));
                    break;
                }
                case DEADLY: {
                    tooltip.add(new TextComponent("- ").m_7220_((Component)new TextComponent("Applies a ")).m_7220_((Component)new TextComponent("Strong ").m_130948_(Style.f_131099_.m_178520_(16209445))).m_7220_((Component)new TextComponent("Negative ").m_130948_(Style.f_131099_.m_178520_(0x910000))).m_7220_((Component)new TextComponent("Modifier")));
                    break;
                }
                case NEUTRAL: {
                    tooltip.add(new TextComponent("- Has no effects"));
                    break;
                }
                case REFINED: {
                    tooltip.add(new TextComponent("- ").m_7220_((Component)new TextComponent("Applies a ")).m_7220_((Component)new TextComponent("Positive ").m_130948_(Style.f_131099_.m_178520_(3203076))).m_7220_((Component)new TextComponent("Modifier")));
                    break;
                }
                case RUTHLESS: {
                    tooltip.add(new TextComponent("- ").m_7220_((Component)new TextComponent("Applies a ")).m_7220_((Component)new TextComponent("Negative ").m_130948_(Style.f_131099_.m_178520_(0x910000))).m_7220_((Component)new TextComponent("Modifier")));
                    break;
                }
                case EMPOWERED: {
                    tooltip.add(new TextComponent("- ").m_7220_((Component)new TextComponent("Applies a ")).m_7220_((Component)new TextComponent("Strong ").m_130948_(Style.f_131099_.m_178520_(16209445))).m_7220_((Component)new TextComponent("Positive ").m_130948_(Style.f_131099_.m_178520_(3203076))).m_7220_((Component)new TextComponent("Modifier")));
                }
            }
            tooltip.add(new TextComponent("- Adds ").m_130948_(Style.f_131099_.m_178520_(0x858383)).m_7220_((Component)new TextComponent(this.config.getFormattedPercentIngredient(ingredient.getType())).m_130948_(Style.f_131099_.m_178520_(15787660))).m_7220_((Component)new TextComponent(" to the Objective Progression")));
            tooltip.add(new TextComponent("- Use 3 of the same ").m_130948_(Style.f_131099_.m_178520_(0x858383)).m_7220_((Component)new TextComponent("Ingredient Type ").m_130948_(Style.f_131099_.m_178520_(15787660))).m_7220_((Component)new TextComponent("to guarantee its modifiers")));
            itemTooltipEvent.getToolTip().addAll(2, tooltip);
        });
        super.initClient(vault);
    }

    public void initServer(VirtualWorld world, Vault vault) {
        this.config = ModConfigs.ALCHEMY_OBJECTIVE.getConfig((Integer)this.get(VAULT_LEVEL));
        AlchemyTasks.initServer(world, vault, this, this.config);
        CommonEvents.OBJECTIVE_PIECE_GENERATION.register((Object)this, data -> this.ifPresent(OBJECTIVE_PROBABILITY, probability -> data.setProbability((double)probability.floatValue())));
        CommonEvents.ENTITY_DROPS.register((Object)this, data -> this.handleChampionDeath((LivingDropsEvent)data, vault, world));
        WoldCommonEvents.BREWING_ALTAR_BREW_EVENT.register((Object)this, data -> this.handleBrewEvent((BrewingAltarBrewEvent.Data)data, vault, world));
        CommonEvents.LISTENER_LEAVE.register((Object)this, data -> {
            if (data.getVault() == vault) {
                if (((Float)this.get(PROGRESS)).floatValue() > ((Float)this.get(REQUIRED_PROGRESS)).floatValue()) {
                    super.tickListener(world, vault, data.getListener());
                } else {
                    ((StatsCollector)vault.get(Vault.STATS)).get((UUID)data.getListener().get(Listener.ID)).set(StatCollector.COMPLETION, (Object)Completion.BAILED);
                }
            }
        });
        this.registerObjectiveTemplate(world, vault);
        super.initServer(world, vault);
    }

    public void tickServer(VirtualWorld world, Vault vault) {
        if (((Float)this.get(PROGRESS)).floatValue() > ((Float)this.get(REQUIRED_PROGRESS)).floatValue()) {
            super.tickServer(world, vault);
        }
    }

    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        if (listener.getPriority((Objective)this) < 0) {
            listener.addObjective(vault, (Objective)this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean render(Vault vault, PoseStack poseStack, Window window, float v, Player player) {
        int midX = window.m_85445_() / 2;
        Font font = Minecraft.m_91087_().f_91062_;
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        if (((Float)this.get(PROGRESS)).floatValue() >= ((Float)this.get(REQUIRED_PROGRESS)).floatValue()) {
            if (!((Boolean)this.get(FULLY_OVERSTACKED)).booleanValue()) {
                MutableComponent txt = new TextComponent("Brew more ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)).m_7220_((Component)new TextComponent("Potions ").m_130948_(Style.f_131099_.m_178520_(15787660))).m_7220_((Component)new TextComponent("for ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent("Crate Quantity").m_130948_(Style.f_131099_.m_178520_(3721664))).m_7220_((Component)new TextComponent(", or Exit to complete ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF))).m_7220_((Component)new TextComponent("the Vault").m_130948_(Style.f_131099_.m_178520_(15787660))).m_7220_((Component)new TextComponent("!").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)));
                FormattedCharSequence var21 = txt.m_7532_();
                float var22 = (float)midX - (float)font.m_92852_((FormattedText)txt) / 2.0f;
                font.m_92733_(var21, var22, 9.0f, -1, true, poseStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
                buffer.m_109911_();
            } else {
                MutableComponent txt = new TextComponent("The Brew is overflowing! Exit to Complete! ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF));
                FormattedCharSequence var21 = txt.m_7532_();
                float var22 = (float)midX - (float)font.m_92852_((FormattedText)txt) / 2.0f;
                font.m_92733_(var21, var22, 9.0f, -1, true, poseStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
                buffer.m_109911_();
            }
        } else {
            float current = ((Float)this.get(PROGRESS)).floatValue();
            float goal = ((Float)this.get(REQUIRED_PROGRESS)).floatValue();
            MutableComponent txt = new TextComponent(String.format("%.1f%%", Float.valueOf(current * 100.0f))).m_7220_((Component)new TextComponent(" / ")).m_7220_((Component)new TextComponent(String.format("%.1f%%", Float.valueOf(goal * 100.0f))));
            float userScale = ((IVaultOptions)Minecraft.m_91087_().f_91066_).getObjectiveScale();
            poseStack.m_85836_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int previousTexture = RenderSystem.m_157203_((int)0);
            RenderSystem.m_157456_((int)0, (ResourceLocation)HUD);
            float progress = current / goal;
            poseStack.m_85837_((double)((float)midX - 80.0f * userScale), (double)(8.0f * userScale), 0.0);
            poseStack.m_85841_(userScale, userScale, userScale);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)200, (int)26, (int)200, (int)100);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)0, (int)8, (float)0.0f, (float)30.0f, (int)(13 + (int)(130.0f * progress)), (int)10, (int)200, (int)100);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157453_((int)0, (int)previousTexture);
            poseStack.m_85849_();
            poseStack.m_85836_();
            float baseScale = 0.6f;
            float totalScale = baseScale * userScale;
            poseStack.m_85841_(totalScale, totalScale, totalScale);
            FormattedCharSequence var10001 = txt.m_7532_();
            float var10002 = (float)midX / totalScale - (float)font.m_92852_((FormattedText)txt) / 2.0f;
            font.m_92733_(var10001, var10002, 31.0f, -1, true, poseStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
            buffer.m_109911_();
            poseStack.m_85849_();
        }
        return true;
    }

    public boolean isActive(VirtualWorld virtualWorld, Vault vault, Objective objective) {
        if (((Float)this.get(PROGRESS)).floatValue() < ((Float)this.get(REQUIRED_PROGRESS)).floatValue()) {
            return objective == this;
        }
        for (Objective child : (Objective.ObjList)this.get(CHILDREN)) {
            if (!child.isActive(virtualWorld, vault, objective)) continue;
            return true;
        }
        return false;
    }

    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    public FieldRegistry getFields() {
        return FIELDS;
    }

    private void handleChampionDeath(LivingDropsEvent event, Vault vault, VirtualWorld world) {
        if (VaultUtils.getVault((Level)event.getEntity().m_183503_()).isEmpty()) {
            return;
        }
        if (!((Vault)VaultUtils.getVault((Level)event.getEntity().m_183503_()).get()).equals(vault)) {
            return;
        }
        Entity entity = event.getEntity();
        if (ChampionLogic.isChampion((Entity)entity) && !entity.m_19880_().contains("no_drops") && event.getSource().m_7639_() instanceof ServerPlayer && entity.f_19853_.f_46441_.nextFloat() >= 0.5f) {
            event.getDrops().add(new ItemEntity(entity.m_183503_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), CatalystItem.createRandomCatalyst(vault, world.m_5822_())));
        }
    }

    private void handleBrewEvent(BrewingAltarBrewEvent.Data data, Vault vault, VirtualWorld world) {
        int crateAmount;
        if (VaultUtils.getVault((Level)data.getWorld()).isEmpty()) {
            return;
        }
        if (!((Vault)VaultUtils.getVault((Level)data.getWorld()).get()).equals(vault)) {
            return;
        }
        BrewingAltarTileEntity.PercentageResult progressIncrease = data.getEntity().getProgressIncrease();
        List<AlchemyIngredientItem> effectIngredients = data.getIngredients().stream().map(ItemStack::m_41720_).filter(item -> item instanceof AlchemyIngredientItem).map(item -> (AlchemyIngredientItem)((Object)item)).filter(item -> item.getType() != AlchemyIngredientItem.AlchemyIngredientType.NEUTRAL).toList();
        if (effectIngredients.isEmpty()) {
            if (data.getEntity().getCatalystType().isPresent()) {
                data.getEntity().getCatalystType().get().applyEffect(world, this, this.config, data, null, null, progressIncrease);
                data.getEntity().removeCatalyst();
            }
            float percentage = progressIncrease.isRange() ? world.m_5822_().nextFloat(progressIncrease.min(), progressIncrease.max()) : progressIncrease.min();
            String formatted = String.format("%.1f%%", Float.valueOf(percentage * 100.0f));
            MutableComponent brewName = AlchemyIngredientItem.AlchemyIngredientType.generatePotionNameComponent(AlchemyIngredientItem.AlchemyIngredientType.getTypes(data.getIngredients()));
            MutableComponent cmp = new TextComponent("Created a ").m_130948_(Style.f_131099_.m_178520_(15787660)).m_7220_((Component)brewName).m_7220_((Component)new TextComponent(" and progressed the vault by ").m_130948_(Style.f_131099_.m_178520_(15787660))).m_7220_((Component)new TextComponent(formatted).m_130948_(Style.f_131099_.m_178520_(percentage >= 0.0f ? 65284 : 14423100)));
            world.m_6907_().forEach(player -> player.m_6352_((Component)cmp, Util.f_137441_));
            this.set(PROGRESS, Float.valueOf(((Float)this.get(PROGRESS)).floatValue() + percentage));
            return;
        }
        AlchemyIngredientItem item2 = effectIngredients.get(world.f_46441_.nextInt(effectIngredients.size()));
        ArrayList<ResourceLocation> modifiers = new ArrayList<ResourceLocation>();
        switch (item2.getType()) {
            case DEADLY: {
                modifiers.add(this.config.getStrongNegativeModifierPool());
                break;
            }
            case RUTHLESS: {
                modifiers.add(this.config.getNegativeModifierPool());
                break;
            }
            case VOLATILE: {
                modifiers.add(this.config.getStrongNegativeModifierPool());
                modifiers.add(this.config.getStrongPositiveModifierPool());
                break;
            }
            case REFINED: {
                modifiers.add(this.config.getPositiveModifierPool());
                break;
            }
            case EMPOWERED: {
                modifiers.add(this.config.getStrongPositiveModifierPool());
            }
        }
        HashMap toAddToVault = new HashMap();
        JavaRandom random = JavaRandom.ofNanoTime();
        for (ResourceLocation mod : modifiers) {
            for (VaultModifier modifier : iskallia.vault.init.ModConfigs.VAULT_MODIFIER_POOLS.getRandom(mod, ((Integer)this.get(VAULT_LEVEL)).intValue(), (RandomSource)random)) {
                toAddToVault.put(modifier, 1);
            }
        }
        if (data.getEntity().getCatalystType().isPresent()) {
            data.getEntity().getCatalystType().get().applyEffect(world, this, this.config, data, toAddToVault, modifiers, progressIncrease);
            data.getEntity().removeCatalyst();
        }
        float percentage = progressIncrease.isRange() ? world.m_5822_().nextFloat(progressIncrease.min(), progressIncrease.max()) : progressIncrease.min();
        String formatted = String.format("%.1f%%", Float.valueOf(percentage * 100.0f));
        MutableComponent brewName = AlchemyIngredientItem.AlchemyIngredientType.generatePotionNameComponent(AlchemyIngredientItem.AlchemyIngredientType.getTypes(data.getIngredients()));
        MutableComponent cmp = new TextComponent("Created a ").m_130948_(Style.f_131099_.m_178520_(15787660)).m_7220_((Component)brewName).m_7220_((Component)new TextComponent(" and progressed the vault by ").m_130948_(Style.f_131099_.m_178520_(15787660))).m_7220_((Component)new TextComponent(formatted).m_130948_(Style.f_131099_.m_178520_(percentage >= 0.0f ? 65284 : 14423100)));
        world.m_6907_().forEach(player -> player.m_6352_((Component)cmp, Util.f_137441_));
        for (Map.Entry entry : toAddToVault.entrySet()) {
            ((Modifiers)vault.get(Vault.MODIFIERS)).addModifier((VaultModifier)entry.getKey(), ((Integer)entry.getValue()).intValue(), true, (RandomSource)random);
            world.m_6907_().forEach(player -> player.m_6352_((Component)new TextComponent("- ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)).m_7220_(((VaultModifier)entry.getKey()).getChatDisplayNameComponent(((Integer)entry.getValue()).intValue())).m_7220_((Component)new TextComponent(" has been applied!").m_130948_(Style.f_131099_.m_178520_(15787660))), Util.f_137441_));
        }
        float oldProgress = ((Float)this.get(PROGRESS)).floatValue();
        float newProgress = oldProgress + percentage;
        this.set(PROGRESS, Float.valueOf(newProgress));
        if (oldProgress < ((Float)this.get(REQUIRED_PROGRESS)).floatValue() && newProgress > ((Float)this.get(REQUIRED_PROGRESS)).floatValue()) {
            if (((Boolean)this.get(FULLY_OVERSTACKED)).booleanValue()) {
                return;
            }
            float overflow = newProgress - ((Float)this.get(REQUIRED_PROGRESS)).floatValue();
            int crateAmount2 = (int)(overflow * 100.0f);
            if (crateAmount2 > 0) {
                VaultModifier crateQuantity = VaultModifierRegistry.get((ResourceLocation)VaultMod.id((String)"crate_quantity"));
                ((Modifiers)vault.get(Vault.MODIFIERS)).addModifier(crateQuantity, crateAmount2, true, (RandomSource)random);
                world.m_6907_().forEach(player -> player.m_6352_((Component)new TextComponent("- Completion has overflown and ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)).m_7220_(crateQuantity.getChatDisplayNameComponent(crateAmount2)).m_7220_((Component)new TextComponent(" has been added!").m_130948_(Style.f_131099_.m_178520_(15787660))), Util.f_137441_));
            }
        } else if (oldProgress >= ((Float)this.get(REQUIRED_PROGRESS)).floatValue() && (crateAmount = (int)(percentage * 100.0f)) > 0) {
            if (((Boolean)this.get(FULLY_OVERSTACKED)).booleanValue()) {
                return;
            }
            VaultModifier crateQuantity = VaultModifierRegistry.get((ResourceLocation)VaultMod.id((String)"crate_quantity"));
            ((Modifiers)vault.get(Vault.MODIFIERS)).addModifier(crateQuantity, crateAmount, true, (RandomSource)random);
            world.m_6907_().forEach(player -> player.m_6352_((Component)new TextComponent("- Completion has overflown and ").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)).m_7220_(crateQuantity.getChatDisplayNameComponent(crateAmount)).m_7220_((Component)new TextComponent(" has been added!").m_130948_(Style.f_131099_.m_178520_(15787660))), Util.f_137441_));
            if (!GameruleHelper.isEnabled(ModGameRules.UNLIMITED_ALCHEMY_OVERSTACKING, (Level)world.m_6018_()) && VaultModifierUtils.hasCountOfModifiers(vault, VaultMod.id((String)"crate_quantity"), (Integer)this.get(OVERSTACK_ALLOWANCE))) {
                this.set(FULLY_OVERSTACKED, true);
                world.m_6907_().forEach(player -> player.m_6352_((Component)new TextComponent("- The Brew is completely overflowing, further ingredients will not add more crate quantity!").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)), Util.f_137441_));
            }
        }
    }
}

