/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.objectives;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.VaultMod;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.IBitAdapter;
import iskallia.vault.core.data.adapter.INbtAdapter;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.data.key.registry.KeyRegistry;
import iskallia.vault.core.data.sync.handler.SyncHandler;
import iskallia.vault.core.event.ClientEvents;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.objective.BingoObjective;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.vault.objective.PvPObjective;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModKeybinds;
import iskallia.vault.task.BingoTask;
import iskallia.vault.task.ProgressConfiguredTask;
import iskallia.vault.task.Task;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.counter.TargetTaskCounter;
import iskallia.vault.task.counter.TaskCounter;
import iskallia.vault.task.renderer.context.RendererContext;
import iskallia.vault.task.renderer.context.TaskRendererContext;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.iwolfking.woldsvaults.api.util.NormalizedHelper;
import xyz.iwolfking.woldsvaults.mixins.vaulthunters.accessors.BingoObjectiveAccessor;

public class BallisticBingoObjective
extends BingoObjective {
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of((String)"ballistic_bingo", Objective.class).with(Version.v1_27, BallisticBingoObjective::new);
    public static final FieldRegistry FIELDS = (FieldRegistry)Objective.FIELDS.merge((KeyRegistry)new FieldRegistry());
    public static final FieldKey<Task> TASK = (FieldKey)FieldKey.of((String)"task", Task.class).with(Version.v1_27, (IBitAdapter)Adapters.TASK_NBT, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
    public static final FieldKey<TaskSource> TASK_SOURCE = (FieldKey)FieldKey.of((String)"task_source", TaskSource.class).with(Version.v1_27, (IBitAdapter)Adapters.TASK_SOURCE_NBT, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
    public static final FieldKey<Integer> JOINED = (FieldKey)FieldKey.of((String)"joined", Integer.class).with(Version.v1_27, (IBitAdapter)Adapters.INT_SEGMENTED_3, DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
    public static final FieldKey<BingoObjective.TaskMap> TASKS = (FieldKey)FieldKey.of((String)"tasks", BingoObjective.TaskMap.class).with(Version.v1_38, (IBitAdapter)CompoundAdapter.of(BingoObjective.TaskMap::new), DISK.all().or((SyncHandler)CLIENT.all())).register((KeyRegistry)FIELDS);
    private boolean pvp;
    private int lastScaledJoined = -1;

    protected BallisticBingoObjective() {
    }

    public static BallisticBingoObjective of(BingoTask task) {
        return (BallisticBingoObjective)new BallisticBingoObjective().set(TASK, task);
    }

    public TaskContext getContext(VirtualWorld world, Vault vault) {
        this.setIfAbsent(TASK_SOURCE, () -> EntityTaskSource.ofUuids((RandomSource)JavaRandom.ofInternal((long)((Long)vault.get(Vault.SEED))), (UUID[])new UUID[0]));
        return TaskContext.of((TaskSource)((TaskSource)this.get(TASK_SOURCE)), (MinecraftServer)world.m_142572_()).setVault(vault);
    }

    private TaskContext getContext(VirtualWorld world, Vault vault, UUID uuid) {
        return TaskContext.of((TaskSource)EntityTaskSource.ofUuids((RandomSource)JavaRandom.ofInternal((long)((Long)vault.get(Vault.SEED))), (UUID[])new UUID[]{uuid}), (MinecraftServer)world.m_142572_()).setVault(vault);
    }

    public boolean isCompleted() {
        BingoTask bingo;
        if (this.pvp) {
            return ((BingoObjective.TaskMap)this.get(TASKS)).values().stream().anyMatch(task -> {
                BingoTask bingo;
                if (task instanceof BingoTask && (bingo = (BingoTask)task).areAllCompleted()) {
                    boolean var10000 = true;
                    return var10000;
                }
                boolean var10000 = false;
                return var10000;
            });
        }
        Object var2 = this.get(TASK);
        if (var2 instanceof BingoTask && (bingo = (BingoTask)var2).areAllCompleted()) {
            boolean var10000 = true;
            return var10000;
        }
        boolean var10000 = false;
        return var10000;
    }

    public int getBingos() {
        int var10000;
        if (this.pvp) {
            return ((BingoObjective.TaskMap)this.get(TASKS)).values().stream().filter(task -> task instanceof BingoTask).map(task -> (BingoTask)task).mapToInt(BingoTask::getCompletedBingos).max().orElse(0);
        }
        Object var2 = this.get(TASK);
        if (var2 instanceof BingoTask) {
            BingoTask bingo = (BingoTask)var2;
            var10000 = bingo.getCompletedBingos();
        } else {
            var10000 = 0;
        }
        return var10000;
    }

    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    public FieldRegistry getFields() {
        return FIELDS;
    }

    public void initServer(VirtualWorld world, Vault vault) {
        NormalizedHelper.handleAddingNormalizedToVault(vault, (ServerLevel)world);
        this.pvp = ((Objectives)vault.get(Vault.OBJECTIVES)).forEach(PvPObjective.class, obj -> true);
        CommonEvents.LISTENER_JOIN.register((Object)this, data -> {
            Listener patt4799$temp;
            if (data.getVault() == vault && (patt4799$temp = data.getListener()) instanceof Runner) {
                Runner runner = (Runner)patt4799$temp;
                if (this.pvp) {
                    if (!((BingoObjective.TaskMap)this.get(TASKS)).containsKey((Object)runner.getId())) {
                        BingoTask board = (BingoTask)((BingoTask)this.get(TASK)).copy();
                        board.onAttach(((BingoObjectiveAccessor)((Object)this)).getContext(world, vault, runner.getId()));
                        ((BingoObjective.TaskMap)this.get(TASKS)).put((Object)runner.getId(), (Object)board);
                    }
                } else {
                    Object patt5225$temp = this.get(TASK_SOURCE);
                    if (patt5225$temp instanceof EntityTaskSource) {
                        EntityTaskSource entitySource = (EntityTaskSource)patt5225$temp;
                        entitySource.add(new UUID[]{runner.getId()});
                    }
                    this.set(JOINED, (Integer)this.getOr(JOINED, 0) + 1);
                }
            }
        });
        CommonEvents.LISTENER_LEAVE.register((Object)this, data -> {
            Listener patt5575$temp;
            if (data.getVault() == vault && (patt5575$temp = data.getListener()) instanceof Runner) {
                Runner runner = (Runner)patt5575$temp;
                if (this.pvp) {
                    BingoTask board = (BingoTask)((BingoObjective.TaskMap)this.get(TASKS)).remove((Object)runner.getId());
                    if (board != null) {
                        board.onDetach();
                    }
                } else {
                    Object patt5819$temp = this.get(TASK_SOURCE);
                    if (patt5819$temp instanceof EntityTaskSource) {
                        EntityTaskSource entitySource = (EntityTaskSource)patt5819$temp;
                        entitySource.remove(new UUID[]{runner.getId()});
                    }
                }
            }
        });
        ((Task)this.get(TASK)).onAttach(this.getContext(world, vault));
        if (this.pvp) {
            for (Runner runner : ((Listeners)vault.get(Vault.LISTENERS)).getAll(Runner.class)) {
                BingoTask board = (BingoTask)((BingoTask)this.get(TASK)).copy();
                board.onAttach(((BingoObjectiveAccessor)((Object)this)).getContext(world, vault, runner.getId()));
                ((BingoObjective.TaskMap)this.get(TASKS)).put((Object)runner.getId(), (Object)board);
            }
            ((Task)this.get(TASK)).onDetach();
        }
        CommonEvents.GRID_GATEWAY_UPDATE.register((Object)this, data -> {
            if (data.getLevel() == world) {
                data.getEntity().setCompletedBingos(this.getBingos());
            }
        });
        ((Objective.ObjList)this.get(CHILDREN)).forEach(child -> child.initServer(world, vault));
    }

    public void tickServer(VirtualWorld world, Vault vault) {
        if (this.getBingos() > 0) {
            ((Objective.ObjList)this.get(CHILDREN)).forEach(child -> child.tickServer(world, vault));
            if (this.isCompleted()) {
                return;
            }
        }
        if (this.pvp) {
            ((BingoObjective.TaskMap)this.get(TASKS)).forEach((uuid, task) -> {
                if (task instanceof BingoTask) {
                    BingoTask bingo = (BingoTask)task;
                    bingo.onTick(((BingoObjectiveAccessor)((Object)this)).getContext(world, vault, (UUID)uuid));
                }
            });
        } else {
            Object var4 = this.get(TASK);
            if (var4 instanceof BingoTask) {
                BingoTask bingo = (BingoTask)var4;
                bingo.onTick(this.getContext(world, vault));
            }
        }
        if (world.getTickCount() % 20 == 0) {
            Object var5;
            int joined = (Integer)this.getOr(JOINED, 0);
            if (this.pvp) {
                ((BingoObjective.TaskMap)this.get(TASKS)).values().forEach(task -> {
                    if (task instanceof BingoTask) {
                        BingoTask root = (BingoTask)task;
                        for (int index = 0; index < root.getWidth() * root.getHeight(); ++index) {
                            if (root.isCompleted(index)) continue;
                            root.getChild(index).streamSelfAndDescendants(ProgressConfiguredTask.class).forEach(t -> {
                                TargetTaskCounter counter;
                                TaskCounter patt7787$temp = t.getCounter();
                                if (patt7787$temp instanceof TargetTaskCounter && (counter = (TargetTaskCounter)patt7787$temp).isPopulated()) {
                                    counter.get("targetPlayerContribution", (INbtAdapter)Adapters.DOUBLE).ifPresent(contribution -> {
                                        Object patt8038$temp = counter.getBaseTarget();
                                        if (patt8038$temp instanceof Integer) {
                                            Integer base = (Integer)patt8038$temp;
                                            counter.setTarget((Object)((int)((double)base.intValue() + contribution * (double)base.intValue())));
                                        } else {
                                            patt8038$temp = counter.getBaseTarget();
                                            if (patt8038$temp instanceof Float) {
                                                Float base = (Float)patt8038$temp;
                                                counter.setTarget((Object)Float.valueOf((float)((double)base.floatValue() + contribution * (double)base.floatValue())));
                                            }
                                        }
                                    });
                                    return;
                                }
                            });
                        }
                    }
                });
            } else if (joined != this.lastScaledJoined && (var5 = this.get(TASK)) instanceof BingoTask) {
                BingoTask root = (BingoTask)var5;
                this.lastScaledJoined = joined;
                for (int index = 0; index < root.getWidth() * root.getHeight(); ++index) {
                    if (root.isCompleted(index)) continue;
                    root.getChild(index).streamSelfAndDescendants(ProgressConfiguredTask.class).forEach(task -> {
                        TargetTaskCounter counter;
                        TaskCounter patt9064$temp = task.getCounter();
                        if (patt9064$temp instanceof TargetTaskCounter && (counter = (TargetTaskCounter)patt9064$temp).isPopulated()) {
                            counter.get("targetPlayerContribution", (INbtAdapter)Adapters.DOUBLE).ifPresent(contribution -> {
                                int additional = Math.max(joined - 1, 0);
                                Object patt9378$temp = counter.getBaseTarget();
                                if (patt9378$temp instanceof Integer) {
                                    Integer base = (Integer)patt9378$temp;
                                    counter.setTarget((Object)((int)((double)base.intValue() + (double)additional * contribution * (double)base.intValue())));
                                } else {
                                    patt9378$temp = counter.getBaseTarget();
                                    if (!(patt9378$temp instanceof Float)) {
                                        throw new UnsupportedOperationException();
                                    }
                                    Float base = (Float)patt9378$temp;
                                    counter.setTarget((Object)Float.valueOf((float)((double)base.floatValue() + (double)additional * contribution * (double)base.floatValue())));
                                }
                            });
                            return;
                        }
                    });
                }
            }
        }
    }

    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        if (listener instanceof Runner && listener.getPriority((Objective)this) < 0) {
            listener.addObjective(vault, (Objective)this);
        }
        if (listener instanceof Runner) {
            Runner runner = (Runner)listener;
            if (this.pvp) {
                BingoTask task = (BingoTask)((BingoObjective.TaskMap)this.get(TASKS)).get((Object)runner.getId());
                if (task != null && task.getCompletedBingos() > 0) {
                    ((Objective.ObjList)this.get(CHILDREN)).forEach(child -> child.tickListener(world, vault, listener));
                }
            } else if (this.getBingos() > 0) {
                ((Objective.ObjList)this.get(CHILDREN)).forEach(child -> child.tickListener(world, vault, listener));
            }
        }
    }

    public void releaseServer() {
        if (this.pvp) {
            ((BingoObjective.TaskMap)this.get(TASKS)).values().forEach(task -> {
                if (task != null) {
                    task.onDetach();
                }
            });
        } else {
            ((Task)this.get(TASK)).onDetach();
        }
        ((Objective.ObjList)this.get(CHILDREN)).forEach(Objective::releaseServer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient(Vault vault) {
        this.pvp = ((Objectives)vault.get(Vault.OBJECTIVES)).forEach(PvPObjective.class, obj -> true);
        ClientEvents.MOUSE_SCROLL.register((Object)vault, event -> {
            if (Minecraft.m_91087_().f_91080_ == null && ModKeybinds.openBingo.m_90857_()) {
                Task task;
                TaskRendererContext context = new TaskRendererContext((PoseStack)null, 0.0f, MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_()), Minecraft.m_91087_().f_91062_);
                UUID uuid = Minecraft.m_91087_().f_91074_ != null ? Minecraft.m_91087_().f_91074_.m_142081_() : null;
                context.setUuid(uuid);
                Task task2 = task = this.pvp && uuid != null ? (Task)((BingoObjective.TaskMap)this.get(TASKS)).get((Object)uuid) : (Task)this.get(TASK);
                if (task != null && task.onMouseScrolled(event.getScrollDelta(), (RendererContext)context)) {
                    event.setCanceled(true);
                }
            }
        });
        ((Objective.ObjList)this.get(CHILDREN)).forEach(child -> child.initClient(vault));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean render(Vault vault, PoseStack poseStack, Window window, float partialTicks, Player player) {
        Task task;
        PvPObjective objective;
        List objs = ((Objectives)vault.get(Vault.OBJECTIVES)).getAll(PvPObjective.class);
        if (!objs.isEmpty() && !(objective = (PvPObjective)objs.get(0)).has(PvPObjective.COUNTDOWN_FINISHED)) {
            return false;
        }
        if (this.isCompleted() && (Minecraft.m_91087_().f_91080_ != null || !ModKeybinds.openBingo.m_90857_())) {
            boolean rendered = false;
            for (Objective objective2 : (Objective.ObjList)this.get(CHILDREN)) {
                rendered |= objective2.render(vault, poseStack, window, partialTicks, player);
            }
            if (rendered) {
                return true;
            }
        }
        Task task2 = task = this.pvp ? (Task)((BingoObjective.TaskMap)this.get(TASKS)).get((Object)player.m_142081_()) : (Task)this.get(TASK);
        if (task == null) {
            return true;
        }
        TaskRendererContext context = new TaskRendererContext(poseStack, partialTicks, MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_()), Minecraft.m_91087_().f_91062_);
        task.onRender((RendererContext)context);
        return true;
    }

    public void addBingoTaskModifier(Vault vault, String modifierPoolName) {
        ChunkRandom random = ChunkRandom.any();
        TextComponent text = new TextComponent("");
        List modifiers = ModConfigs.VAULT_MODIFIER_POOLS.getRandom(VaultMod.id((String)modifierPoolName), 0, (RandomSource)JavaRandom.ofNanoTime());
        if (!modifiers.isEmpty()) {
            Iterator modIter = modifiers.iterator();
            while (modIter.hasNext()) {
                VaultModifier mod = (VaultModifier)modIter.next();
                TextComponent suffix = (TextComponent)mod.getChatDisplayNameComponent(1);
                text.m_130946_("The task completion").m_7220_((Component)new TextComponent(" added ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)suffix).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY));
                if (modIter.hasNext()) {
                    text.m_130946_("\n");
                }
                ((Modifiers)vault.get(Vault.MODIFIERS)).addModifier(mod, 1, true, (RandomSource)random);
            }
            for (Listener listener : ((Listeners)vault.get(Vault.LISTENERS)).getAll()) {
                listener.getPlayer().ifPresent(other -> other.m_5661_((Component)text, false));
            }
        }
    }

    public void onScroll(Player player, double delta) {
        if (this.pvp) {
            Task t;
            if (((BingoObjective.TaskMap)this.get(TASKS)).containsKey((Object)player.m_142081_()) && (t = (Task)((BingoObjective.TaskMap)this.get(TASKS)).get((Object)player.m_142081_())) instanceof BingoTask) {
                BingoTask board = (BingoTask)t;
                board.progressBingoLine(player.m_142081_(), delta < 0.0 ? 1 : -1);
            }
        } else {
            Object var7 = this.get(TASK);
            if (var7 instanceof BingoTask) {
                BingoTask bingo = (BingoTask)var7;
                bingo.progressBingoLine(player.m_142081_(), delta < 0.0 ? 1 : -1);
            }
        }
    }

    public boolean isActive(VirtualWorld world, Vault vault, Objective objective) {
        if (this.isCompleted()) {
            for (Objective child : (Objective.ObjList)this.get(CHILDREN)) {
                if (!child.isActive(world, vault, objective)) continue;
                return true;
            }
            return false;
        }
        if (this.getBingos() > 0) {
            for (Objective child : (Objective.ObjList)this.get(CHILDREN)) {
                if (!child.isActive(world, vault, objective)) continue;
                return true;
            }
        }
        return objective == this;
    }
}

