/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.objectives;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import iskallia.vault.VaultMod;
import iskallia.vault.block.ObeliskBlock;
import iskallia.vault.block.PlaceholderBlock;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.compound.UUIDList;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.BlockSetEvent;
import iskallia.vault.core.event.common.BlockUseEvent;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.objective.ObeliskObjective;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import xyz.iwolfking.woldsvaults.api.util.NormalizedHelper;
import xyz.iwolfking.woldsvaults.objectives.data.BrutalBossesRegistry;
import xyz.iwolfking.woldsvaults.objectives.data.bosses.WoldBoss;

public class BrutalBossesObjective
extends ObeliskObjective {
    public static final SupplierKey<Objective> E_KEY = (SupplierKey)SupplierKey.of((String)"brutal_bosses", Objective.class).with(Version.v1_12, BrutalBossesObjective::new);

    public BrutalBossesObjective(int target, IntSupplier wave, float objectiveProbability) {
        super(target, wave, objectiveProbability);
    }

    public BrutalBossesObjective() {
    }

    public SupplierKey<Objective> getKey() {
        return E_KEY;
    }

    public static BrutalBossesObjective of(int target, IntSupplier wave, float objectiveProbability) {
        return new BrutalBossesObjective(target, wave, objectiveProbability);
    }

    public void initServer(VirtualWorld world, Vault vault) {
        NormalizedHelper.handleAddingNormalizedToVault(vault, (ServerLevel)world);
        CommonEvents.OBJECTIVE_PIECE_GENERATION.register((Object)this, data -> this.ifPresent(OBJECTIVE_PROBABILITY, probability -> data.setProbability((double)probability.floatValue())));
        CommonEvents.BLOCK_USE.in((Level)world).at(BlockUseEvent.Phase.HEAD).of((Block)ModBlocks.OBELISK).register((Object)this, data -> {
            if (data.getHand() != InteractionHand.MAIN_HAND) {
                data.setResult(InteractionResult.SUCCESS);
            } else if (this.hasObelisksLeft()) {
                BlockPos pos = data.getPos();
                if (((Boolean)data.getState().m_61143_((Property)ObeliskBlock.FILLED)).booleanValue()) {
                    data.setResult(InteractionResult.SUCCESS);
                } else if (data.getState().m_61143_((Property)ObeliskBlock.HALF) == DoubleBlockHalf.UPPER && world.m_8055_(pos = pos.m_7495_()).m_60734_() != ModBlocks.OBELISK) {
                    data.setResult(InteractionResult.SUCCESS);
                } else if (((Listeners)vault.get(Vault.LISTENERS)).getObjectivePriority(data.getPlayer().m_142081_(), (Objective)this) != 0) {
                    data.setResult(InteractionResult.SUCCESS);
                } else {
                    world.m_7731_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)ObeliskBlock.FILLED, (Comparable)Boolean.valueOf(true)), 3);
                    world.m_7731_(pos.m_7494_(), (BlockState)world.m_8055_(pos.m_7494_()).m_61124_((Property)ObeliskBlock.FILLED, (Comparable)Boolean.valueOf(true)), 3);
                    this.onObeliskActivated(world, vault, pos);
                    data.setResult(InteractionResult.SUCCESS);
                }
            }
        });
        this.registerObjectiveTemplate(world, vault);
        CommonEvents.BLOCK_SET.at(BlockSetEvent.Type.RETURN).in((LevelWriter)world).register((Object)this, data -> {
            PartialTile target = PartialTile.of((PartialBlockState)PartialBlockState.of((Block)ModBlocks.PLACEHOLDER), (PartialCompoundNbt)PartialCompoundNbt.empty());
            target.getState().set((Property)PlaceholderBlock.TYPE, (Comparable)PlaceholderBlock.Type.OBJECTIVE);
            if (target.isSubsetOf(PartialTile.of((BlockState)data.getState()))) {
                BlockState lower = (BlockState)((BlockState)ModBlocks.OBELISK.m_49966_().m_61124_((Property)ObeliskBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)ObeliskBlock.FILLED, (Comparable)Boolean.valueOf(false));
                BlockState upper = (BlockState)((BlockState)ModBlocks.OBELISK.m_49966_().m_61124_((Property)ObeliskBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)ObeliskBlock.FILLED, (Comparable)Boolean.valueOf(false));
                data.getWorld().m_7731_(data.getPos(), lower, 3);
                data.getWorld().m_7731_(data.getPos().m_7494_(), upper, 3);
            }
        });
        CommonEvents.ENTITY_DEATH.register((Object)this, event -> {
            if (event.getEntity().f_19853_ == world) {
                for (ObeliskObjective.Wave wave : (ObeliskObjective.Wave[])this.get(WAVES)) {
                    if (!((UUIDList)wave.get(ObeliskObjective.Wave.MOBS)).remove((Object)event.getEntity().m_142081_())) continue;
                    wave.modify(ObeliskObjective.Wave.COUNT, x -> x + 1);
                    MobModifier modifier = InfernalMobsCore.getMobModifiers((LivingEntity)event.getEntityLiving());
                    ArrayList<VaultModifier> modifiersForMsg = new ArrayList<VaultModifier>();
                    if (modifier != null && modifier.getModSize() != 0) {
                        String modNames = modifier.getLinkedModNameUntranslated().trim();
                        for (String modName : modNames.split("\\s+")) {
                            List modifiers = ModConfigs.VAULT_MODIFIER_POOLS.getRandom(VaultMod.id((String)("bb_" + modName.toLowerCase())), 0, (RandomSource)JavaRandom.ofNanoTime());
                            if (modifiers.isEmpty()) continue;
                            for (VaultModifier mod : modifiers) {
                                modifiersForMsg.add(mod);
                                ((Modifiers)vault.get(Vault.MODIFIERS)).addModifier(mod, 1, true, (RandomSource)JavaRandom.ofNanoTime());
                            }
                        }
                    } else {
                        for (int i = 0; i < 2; ++i) {
                            String modName = ((String)BrutalBossesRegistry.BOSS_MODS_LIST.getRandom().get()).toLowerCase();
                            List modifiers = ModConfigs.VAULT_MODIFIER_POOLS.getRandom(VaultMod.id((String)("bb_" + modName)), 0, (RandomSource)JavaRandom.ofNanoTime());
                            if (modifiers.isEmpty()) continue;
                            for (VaultModifier mod : modifiers) {
                                modifiersForMsg.add(mod);
                                ((Modifiers)vault.get(Vault.MODIFIERS)).addModifier(mod, 1, true, (RandomSource)JavaRandom.ofNanoTime());
                            }
                        }
                    }
                    ((Listeners)vault.get(Vault.LISTENERS)).getAll().forEach(listener -> {
                        if (listener.getPlayer().isPresent()) {
                            modifiersForMsg.forEach(mod -> ((ServerPlayer)listener.getPlayer().get()).m_5661_((Component)mod.getChatDisplayNameComponent(1).m_6881_().m_130946_(" was added to The Vault!"), false));
                        }
                    });
                }
            }
        });
        ((Objective.ObjList)this.get(CHILDREN)).forEach(child -> child.initServer(world, vault));
    }

    private void onObeliskActivated(VirtualWorld world, Vault vault, BlockPos pos) {
        this.playActivationEffects(world, pos);
        ObeliskObjective.Wave wave = Arrays.stream((ObeliskObjective.Wave[])this.get(WAVES)).filter(w -> !w.has(ObeliskObjective.Wave.ACTIVE)).findFirst().orElseThrow();
        wave.set(ObeliskObjective.Wave.ACTIVE);
        JavaRandom random = JavaRandom.ofNanoTime();
        for (int i = 0; i < (Integer)wave.get(ObeliskObjective.Wave.TARGET); ++i) {
            ((UUIDList)wave.get(ObeliskObjective.Wave.MOBS)).add((Object)this.doSpawn(world, vault, pos, (RandomSource)random).m_142081_());
        }
    }

    public LivingEntity doSpawn(VirtualWorld world, Vault vault, BlockPos pos, RandomSource random) {
        double min = 10.0;
        double max = 13.0;
        LivingEntity spawned = null;
        while (spawned == null) {
            double angle = Math.PI * 2 * random.nextDouble();
            double distance = Math.sqrt(random.nextDouble() * (max * max - min * min) + min * min);
            int x = (int)Math.ceil(distance * Math.cos(angle));
            int z = (int)Math.ceil(distance * Math.sin(angle));
            double xzRadius = Math.sqrt(x * x + z * z);
            double yRange = Math.sqrt(max * max - xzRadius * xzRadius);
            int y = random.nextInt((int)Math.ceil(yRange) * 2 + 1) - (int)Math.ceil(yRange);
            spawned = BrutalBossesObjective.spawnMob(world, vault, pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z, random);
        }
        return spawned;
    }

    @Nullable
    public static LivingEntity spawnMob(VirtualWorld world, Vault vault, int x, int y, int z, RandomSource random) {
        EntityType type = (EntityType)BrutalBossesRegistry.BOSS_LIST.getRandom().get();
        Component bossName = (Component)BrutalBossesRegistry.BOSS_NAME_LIST.getRandom().get();
        LivingEntity entity = (LivingEntity)type.m_20615_((Level)world);
        assert (entity != null);
        entity.m_146915_(true);
        if (entity instanceof WoldBoss) {
            entity.m_6593_((Component)new TextComponent("Wold").m_130940_(ChatFormatting.GOLD));
        } else {
            entity.m_6593_(bossName);
        }
        entity.m_20340_(true);
        InfernalMobsCore.instance().addEntityModifiersByString(entity, BrutalBossesRegistry.getRandomMobModifiers());
        BlockState state = world.m_8055_(new BlockPos(x, y - 1, z));
        if (!state.m_60643_((BlockGetter)world, new BlockPos(x, y - 1, z), entity.m_6095_())) {
            return null;
        }
        AABB entityBox = entity.m_6095_().m_20585_((double)x + 0.5, (double)y, (double)z + 0.5);
        if (!world.m_45772_(entityBox)) {
            return null;
        }
        entity.m_7678_((double)((float)x + 0.5f), (double)((float)y + 0.2f), (double)((float)z + 0.5f), (float)(random.nextDouble() * 2.0 * Math.PI), 0.0f);
        world.m_8847_((Entity)entity);
        return entity;
    }
}

